/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.sum;

import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.parser.tree.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Merger;

public class DoubleSumKudaf
extends KsqlAggregateFunction<Double, Double> {
    DoubleSumKudaf(int argIndexInValue) {
        super(argIndexInValue, () -> 0.0, Schema.FLOAT64_SCHEMA, Collections.singletonList(Schema.FLOAT64_SCHEMA));
    }

    @Override
    public Double aggregate(Double currentVal, Double currentAggVal) {
        return currentVal + currentAggVal;
    }

    @Override
    public Merger<String, Double> getMerger() {
        return (aggKey, aggOne, aggTwo) -> aggOne + aggTwo;
    }

    @Override
    public KsqlAggregateFunction<Double, Double> getInstance(Map<String, Integer> expressionNames, List<Expression> functionArguments) {
        int udafIndex = expressionNames.get(functionArguments.get(0).toString());
        return new DoubleSumKudaf(udafIndex);
    }
}

