/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.min;

import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.parser.tree.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Merger;

public class IntegerMinKudaf
extends KsqlAggregateFunction<Integer, Integer> {
    IntegerMinKudaf(int argIndexInValue) {
        super(argIndexInValue, () -> Integer.MAX_VALUE, Schema.INT32_SCHEMA, Collections.singletonList(Schema.INT32_SCHEMA));
    }

    @Override
    public Integer aggregate(Integer currentVal, Integer currentAggVal) {
        if (currentVal == null) {
            return currentAggVal;
        }
        return Math.min(currentVal, currentAggVal);
    }

    @Override
    public Merger<String, Integer> getMerger() {
        return (aggKey, aggOne, aggTwo) -> Math.min(aggOne, aggTwo);
    }

    @Override
    public KsqlAggregateFunction<Integer, Integer> getInstance(Map<String, Integer> expressionNames, List<Expression> functionArguments) {
        int udafIndex = expressionNames.get(functionArguments.get(0).toString());
        return new IntegerMinKudaf(udafIndex);
    }
}

