/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf;

import io.confluent.ksql.GenericRow;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.streams.kstream.Initializer;

public class KudafInitializer
implements Initializer<GenericRow> {
    private final List<Supplier> aggValueSuppliers = new ArrayList<Supplier>();
    private final int nonAggValSize;

    public KudafInitializer(int nonAggValSize) {
        this.nonAggValSize = nonAggValSize;
    }

    public GenericRow apply() {
        List values = IntStream.range(0, this.nonAggValSize).mapToObj(value -> null).collect(Collectors.toList());
        this.aggValueSuppliers.forEach(supplier -> values.add(supplier.get()));
        return new GenericRow(values);
    }

    public void addAggregateIntializer(Supplier intialValueSupplier) {
        this.aggValueSuppliers.add(intialValueSupplier);
    }
}

