/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Merger;

public abstract class KsqlAggregateFunction<V, A> {
    private final int argIndexInValue;
    private final Supplier<A> initialValueSupplier;
    private final Schema returnType;
    private final List<Schema> arguments;

    public KsqlAggregateFunction(Integer argIndexInValue) {
        this(argIndexInValue, null, null, null);
    }

    public KsqlAggregateFunction(int argIndexInValue, Supplier<A> initialValueSupplier, Schema returnType, List<Schema> arguments) {
        this.argIndexInValue = argIndexInValue;
        this.initialValueSupplier = initialValueSupplier;
        this.returnType = returnType;
        this.arguments = arguments;
    }

    public abstract KsqlAggregateFunction<V, A> getInstance(Map<String, Integer> var1, List<Expression> var2);

    public boolean hasSameArgTypes(List<Schema> argTypeList) {
        if (argTypeList == null) {
            throw new KsqlException("Argument type list is null.");
        }
        return this.arguments.equals(argTypeList);
    }

    public abstract A aggregate(V var1, A var2);

    public Supplier<A> getInitialValueSupplier() {
        return this.initialValueSupplier;
    }

    public int getArgIndexInValue() {
        return this.argIndexInValue;
    }

    public Schema getReturnType() {
        return this.returnType;
    }

    public List<Schema> getArguments() {
        return this.arguments;
    }

    public abstract Merger<String, A> getMerger();
}

