/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.function.udaf.count.CountAggFunctionFactory;
import io.confluent.ksql.function.udaf.max.MaxAggFunctionFactory;
import io.confluent.ksql.function.udaf.min.MinAggFunctionFactory;
import io.confluent.ksql.function.udaf.sum.SumAggFunctionFactory;
import io.confluent.ksql.function.udaf.topk.TopKAggregateFunctionFactory;
import io.confluent.ksql.function.udaf.topkdistinct.TopkDistinctAggFunctionFactory;
import io.confluent.ksql.function.udf.datetime.StringToTimestamp;
import io.confluent.ksql.function.udf.datetime.TimestampToString;
import io.confluent.ksql.function.udf.json.ArrayContainsKudf;
import io.confluent.ksql.function.udf.json.JsonExtractStringKudf;
import io.confluent.ksql.function.udf.math.AbsKudf;
import io.confluent.ksql.function.udf.math.CeilKudf;
import io.confluent.ksql.function.udf.math.FloorKudf;
import io.confluent.ksql.function.udf.math.RandomKudf;
import io.confluent.ksql.function.udf.math.RoundKudf;
import io.confluent.ksql.function.udf.string.ConcatKudf;
import io.confluent.ksql.function.udf.string.IfNullKudf;
import io.confluent.ksql.function.udf.string.LCaseKudf;
import io.confluent.ksql.function.udf.string.LenKudf;
import io.confluent.ksql.function.udf.string.SubstringKudf;
import io.confluent.ksql.function.udf.string.TrimKudf;
import io.confluent.ksql.function.udf.string.UCaseKudf;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.util.ExpressionTypeManager;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class FunctionRegistry {
    private Map<String, KsqlFunction> ksqlFunctionMap = new HashMap<String, KsqlFunction>();
    private Map<String, AggregateFunctionFactory> aggregateFunctionMap = new HashMap<String, AggregateFunctionFactory>();

    public FunctionRegistry() {
        this.init();
    }

    private void init() {
        KsqlFunction lcase = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA), "LCASE", LCaseKudf.class);
        this.addFunction(lcase);
        KsqlFunction ucase = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA), "UCASE", UCaseKudf.class);
        this.addFunction(ucase);
        KsqlFunction substring = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA, Schema.INT32_SCHEMA, Schema.INT32_SCHEMA), "SUBSTRING", SubstringKudf.class);
        this.addFunction(substring);
        KsqlFunction concat = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA), "CONCAT", ConcatKudf.class);
        this.addFunction(concat);
        KsqlFunction trim = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA), "TRIM", TrimKudf.class);
        this.addFunction(trim);
        KsqlFunction ifNull = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA), "IFNULL", IfNullKudf.class);
        this.addFunction(ifNull);
        KsqlFunction len = new KsqlFunction(Schema.INT32_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA), "LEN", LenKudf.class);
        this.addFunction(len);
        KsqlFunction abs = new KsqlFunction(Schema.FLOAT64_SCHEMA, Arrays.asList(Schema.FLOAT64_SCHEMA), "ABS", AbsKudf.class);
        this.addFunction(abs);
        KsqlFunction ceil = new KsqlFunction(Schema.FLOAT64_SCHEMA, Arrays.asList(Schema.FLOAT64_SCHEMA), "CEIL", CeilKudf.class);
        this.addFunction(ceil);
        KsqlFunction floor = new KsqlFunction(Schema.FLOAT64_SCHEMA, Arrays.asList(Schema.FLOAT64_SCHEMA), "FLOOR", FloorKudf.class);
        this.addFunction(floor);
        KsqlFunction round = new KsqlFunction(Schema.INT64_SCHEMA, Arrays.asList(Schema.FLOAT64_SCHEMA), "ROUND", RoundKudf.class);
        this.addFunction(round);
        KsqlFunction random = new KsqlFunction(Schema.FLOAT64_SCHEMA, new ArrayList<Schema>(), "RANDOM", RandomKudf.class);
        this.addFunction(random);
        KsqlFunction timestampToString = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.INT64_SCHEMA, Schema.STRING_SCHEMA), "TIMESTAMPTOSTRING", TimestampToString.class);
        this.addFunction(timestampToString);
        KsqlFunction stringToTimestamp = new KsqlFunction(Schema.INT64_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA), "STRINGTOTIMESTAMP", StringToTimestamp.class);
        this.addFunction(stringToTimestamp);
        KsqlFunction getStringFromJson = new KsqlFunction(Schema.STRING_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA), "EXTRACTJSONFIELD", JsonExtractStringKudf.class);
        this.addFunction(getStringFromJson);
        KsqlFunction jsonArrayContainsString = new KsqlFunction(Schema.BOOLEAN_SCHEMA, Arrays.asList(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA), "ARRAYCONTAINS", ArrayContainsKudf.class);
        this.addFunction(jsonArrayContainsString);
        this.addFunction(new KsqlFunction(Schema.BOOLEAN_SCHEMA, Arrays.asList(SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).build(), Schema.STRING_SCHEMA), "ARRAYCONTAINS", ArrayContainsKudf.class));
        this.addFunction(new KsqlFunction(Schema.BOOLEAN_SCHEMA, Arrays.asList(SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build(), Schema.INT32_SCHEMA), "ARRAYCONTAINS", ArrayContainsKudf.class));
        this.addFunction(new KsqlFunction(Schema.BOOLEAN_SCHEMA, Arrays.asList(SchemaBuilder.array((Schema)Schema.INT64_SCHEMA).build(), Schema.INT64_SCHEMA), "ARRAYCONTAINS", ArrayContainsKudf.class));
        this.addFunction(new KsqlFunction(Schema.BOOLEAN_SCHEMA, Arrays.asList(SchemaBuilder.array((Schema)Schema.FLOAT64_SCHEMA).build(), Schema.FLOAT64_SCHEMA), "ARRAYCONTAINS", ArrayContainsKudf.class));
        this.addAggregateFunctionFactory(new CountAggFunctionFactory());
        this.addAggregateFunctionFactory(new SumAggFunctionFactory());
        this.addAggregateFunctionFactory(new MaxAggFunctionFactory());
        this.addAggregateFunctionFactory(new MinAggFunctionFactory());
        this.addAggregateFunctionFactory(new TopKAggregateFunctionFactory());
        this.addAggregateFunctionFactory(new TopkDistinctAggFunctionFactory());
    }

    public KsqlFunction getFunction(String functionName) {
        return this.ksqlFunctionMap.get(functionName);
    }

    private void addFunction(KsqlFunction ksqlFunction) {
        this.ksqlFunctionMap.put(ksqlFunction.getFunctionName().toUpperCase(), ksqlFunction);
    }

    public boolean isAnAggregateFunction(String functionName) {
        return this.aggregateFunctionMap.containsKey(functionName);
    }

    public KsqlAggregateFunction getAggregateFunction(String functionName, List<Expression> functionArgs, Schema schema) {
        AggregateFunctionFactory aggregateFunctionFactory = this.aggregateFunctionMap.get(functionName);
        if (aggregateFunctionFactory == null) {
            throw new KsqlException("No aggregate function with name " + functionName + " exists!");
        }
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(schema, this);
        Schema expressionType = expressionTypeManager.getExpressionType(functionArgs.get(0));
        return aggregateFunctionFactory.getProperAggregateFunction(Arrays.asList(expressionType));
    }

    public void addAggregateFunctionFactory(AggregateFunctionFactory aggregateFunctionFactory) {
        this.aggregateFunctionMap.put(aggregateFunctionFactory.functionName, aggregateFunctionFactory);
    }
}

