/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.QueryTerminator;
import io.confluent.ksql.ddl.commands.DDLCommand;
import io.confluent.ksql.ddl.commands.DDLCommandResult;
import io.confluent.ksql.ddl.commands.DropTopicCommand;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.parser.tree.AbstractStreamDropStatement;
import io.confluent.ksql.serde.DataSource;
import io.confluent.ksql.util.KsqlException;

public class DropSourceCommand
implements DDLCommand {
    private final String sourceName;
    private final DataSource.DataSourceType dataSourceType;
    private final QueryTerminator queryTerminator;

    public DropSourceCommand(AbstractStreamDropStatement statement, DataSource.DataSourceType dataSourceType, QueryTerminator queryTerminator) {
        this.sourceName = statement.getName().getSuffix();
        this.dataSourceType = dataSourceType;
        this.queryTerminator = queryTerminator;
    }

    @Override
    public DDLCommandResult run(MetaStore metaStore) {
        StructuredDataSource dataSource = metaStore.getSource(this.sourceName);
        if (dataSource == null) {
            throw new KsqlException("Source " + this.sourceName + " does not exist.");
        }
        if (dataSource.getDataSourceType() != this.dataSourceType) {
            throw new KsqlException(String.format("Incompatible data source type is %s, but statement was DROP %s", dataSource.getDataSourceType() == DataSource.DataSourceType.KSTREAM ? "STREAM" : "TABLE", this.dataSourceType == DataSource.DataSourceType.KSTREAM ? "STREAM" : "TABLE"));
        }
        DropTopicCommand dropTopicCommand = new DropTopicCommand(dataSource.getKsqlTopic().getTopicName());
        dropTopicCommand.run(metaStore);
        metaStore.deleteSource(this.sourceName);
        this.queryTerminator.terminateQueryForEntity(this.sourceName);
        return new DDLCommandResult(true, "Source " + this.sourceName + " was dropped");
    }
}

