/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.ddl.commands.DDLCommand;
import io.confluent.ksql.ddl.commands.DDLCommandResult;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.util.KsqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDLCommandExec {
    private static final Logger LOGGER = LoggerFactory.getLogger(DDLCommandExec.class);
    private final MetaStore metaStore;

    public DDLCommandExec(MetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public DDLCommandResult tryExecute(DDLCommand ddlCommand, MetaStore tempMetaStore) {
        if (tempMetaStore == this.metaStore) {
            throw new KsqlException("Try to execute DDLCommand on tempMetaStore, but getting the real MetaStore.");
        }
        return DDLCommandExec.executeOnMetaStore(ddlCommand, tempMetaStore);
    }

    public DDLCommandResult execute(DDLCommand ddlCommand) {
        return DDLCommandExec.executeOnMetaStore(ddlCommand, this.metaStore);
    }

    private static DDLCommandResult executeOnMetaStore(DDLCommand ddlCommand, MetaStore metaStore) {
        try {
            return ddlCommand.run(metaStore);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("executeOnMetaStore:%s", ddlCommand), (Throwable)e);
            return new DDLCommandResult(false, e.getMessage());
        }
    }
}

