/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.QueryTerminator;
import io.confluent.ksql.ddl.commands.CreateStreamCommand;
import io.confluent.ksql.ddl.commands.CreateTableCommand;
import io.confluent.ksql.ddl.commands.DDLCommand;
import io.confluent.ksql.ddl.commands.DDLCommandFactory;
import io.confluent.ksql.ddl.commands.DropSourceCommand;
import io.confluent.ksql.ddl.commands.DropTopicCommand;
import io.confluent.ksql.ddl.commands.RegisterTopicCommand;
import io.confluent.ksql.ddl.commands.SetPropertyCommand;
import io.confluent.ksql.parser.tree.AbstractStreamDropStatement;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.DDLStatement;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.DropTopic;
import io.confluent.ksql.parser.tree.RegisterTopic;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.serde.DataSource;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.KsqlException;
import java.util.HashMap;
import java.util.Map;

public class CommandFactories
implements DDLCommandFactory {
    private final Map<Class<? extends DDLStatement>, DDLCommandFactory> factories = new HashMap<Class<? extends DDLStatement>, DDLCommandFactory>();

    public CommandFactories(KafkaTopicClient topicClient, QueryTerminator queryTerminator, boolean enforceTopicExistence) {
        this.factories.put(RegisterTopic.class, (sqlExpression, ddlStatement, properties) -> new RegisterTopicCommand((RegisterTopic)ddlStatement));
        this.factories.put(CreateStream.class, (sqlExpression, ddlStatement, properties) -> new CreateStreamCommand(sqlExpression, (CreateStream)ddlStatement, (Map<String, Object>)properties, topicClient, enforceTopicExistence));
        this.factories.put(CreateTable.class, (sqlExpression, ddlStatement, properties) -> new CreateTableCommand(sqlExpression, (CreateTable)ddlStatement, (Map<String, Object>)properties, topicClient, enforceTopicExistence));
        this.factories.put(DropStream.class, (sqlExpression, ddlStatement, properties) -> new DropSourceCommand((AbstractStreamDropStatement)((DropStream)ddlStatement), DataSource.DataSourceType.KSTREAM, queryTerminator));
        this.factories.put(DropTable.class, (sqlExpression, ddlStatement, properties) -> new DropSourceCommand((AbstractStreamDropStatement)((DropTable)ddlStatement), DataSource.DataSourceType.KTABLE, queryTerminator));
        this.factories.put(DropTopic.class, (sqlExpression, ddlStatement, properties) -> new DropTopicCommand((DropTopic)ddlStatement));
        this.factories.put(SetProperty.class, (sqlExpression, ddlStatement, properties) -> new SetPropertyCommand((SetProperty)ddlStatement, properties));
    }

    @Override
    public DDLCommand create(String sqlExpression, DDLStatement ddlStatement, Map<String, Object> properties) {
        if (!this.factories.containsKey(ddlStatement.getClass())) {
            throw new KsqlException("Unable to find ddl command factory for statement:" + ddlStatement.getClass() + " valid statements:" + this.factories.keySet());
        }
        return this.factories.get(ddlStatement.getClass()).create(sqlExpression, ddlStatement, properties);
    }
}

