/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.codegen;

import com.google.common.base.Joiner;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.BetweenPredicate;
import io.confluent.ksql.parser.tree.BinaryLiteral;
import io.confluent.ksql.parser.tree.BooleanLiteral;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.DecimalLiteral;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.DoubleLiteral;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.FieldReference;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.GenericLiteral;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.LogicalBinaryExpression;
import io.confluent.ksql.parser.tree.LongLiteral;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NotExpression;
import io.confluent.ksql.parser.tree.NullLiteral;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.parser.tree.StringLiteral;
import io.confluent.ksql.parser.tree.SubscriptExpression;
import io.confluent.ksql.parser.tree.SymbolReference;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.SchemaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class SqlToJavaVisitor {
    private Schema schema;
    private FunctionRegistry functionRegistry;

    public SqlToJavaVisitor(Schema schema, FunctionRegistry functionRegistry) {
        this.schema = schema;
        this.functionRegistry = functionRegistry;
    }

    public String process(Expression expression) {
        return this.formatExpression(expression);
    }

    private String formatExpression(Expression expression) {
        Pair expressionFormatterResult = (Pair)new Formatter(this.functionRegistry).process((Node)expression, true);
        return (String)expressionFormatterResult.getLeft();
    }

    public class Formatter
    extends AstVisitor<Pair<String, Schema>, Boolean> {
        FunctionRegistry functionRegistry;

        Formatter(FunctionRegistry functionRegistry) {
            this.functionRegistry = functionRegistry;
        }

        protected Pair<String, Schema> visitNode(Node node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitExpression(Expression node, Boolean unmangleNames) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", ((Object)((Object)this)).getClass().getName(), node.getClass().getSimpleName()));
        }

        protected Pair<String, Schema> visitBooleanLiteral(BooleanLiteral node, Boolean unmangleNames) {
            return new Pair((Object)String.valueOf(node.getValue()), (Object)Schema.BOOLEAN_SCHEMA);
        }

        protected Pair<String, Schema> visitStringLiteral(StringLiteral node, Boolean unmangleNames) {
            return new Pair((Object)("\"" + node.getValue() + "\""), (Object)Schema.STRING_SCHEMA);
        }

        protected Pair<String, Schema> visitBinaryLiteral(BinaryLiteral node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitDoubleLiteral(DoubleLiteral node, Boolean unmangleNames) {
            return new Pair((Object)Double.toString(node.getValue()), (Object)Schema.FLOAT64_SCHEMA);
        }

        protected Pair<String, Schema> visitDecimalLiteral(DecimalLiteral node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitGenericLiteral(GenericLiteral node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitNullLiteral(NullLiteral node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitQualifiedNameReference(QualifiedNameReference node, Boolean unmangleNames) {
            String fieldName = this.formatQualifiedName(node.getName());
            Optional schemaField = SchemaUtil.getFieldByName((Schema)SqlToJavaVisitor.this.schema, (String)fieldName);
            if (!schemaField.isPresent()) {
                throw new KsqlException("Field not found: " + fieldName);
            }
            return new Pair((Object)fieldName.replace(".", "_"), (Object)((Field)schemaField.get()).schema());
        }

        protected Pair<String, Schema> visitSymbolReference(SymbolReference node, Boolean context) {
            String fieldName = this.formatIdentifier(node.getName());
            Optional schemaField = SchemaUtil.getFieldByName((Schema)SqlToJavaVisitor.this.schema, (String)fieldName);
            if (!schemaField.isPresent()) {
                throw new KsqlException("Field not found: " + fieldName);
            }
            return new Pair((Object)fieldName, (Object)((Field)schemaField.get()).schema());
        }

        protected Pair<String, Schema> visitDereferenceExpression(DereferenceExpression node, Boolean unmangleNames) {
            String fieldName = node.toString();
            Optional schemaField = SchemaUtil.getFieldByName((Schema)SqlToJavaVisitor.this.schema, (String)fieldName);
            if (!schemaField.isPresent()) {
                throw new KsqlException("Field not found: " + fieldName);
            }
            return new Pair((Object)fieldName.replace(".", "_"), (Object)((Field)schemaField.get()).schema());
        }

        private String formatQualifiedName(QualifiedName name) {
            ArrayList<String> parts = new ArrayList<String>();
            for (String part : name.getParts()) {
                parts.add(this.formatIdentifier(part));
            }
            return Joiner.on((char)'.').join(parts);
        }

        public Pair<String, Schema> visitFieldReference(FieldReference node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitLongLiteral(LongLiteral node, Boolean unmangleNames) {
            return new Pair((Object)("Long.parseLong(\"" + node.getValue() + "\")"), (Object)Schema.INT64_SCHEMA);
        }

        protected Pair<String, Schema> visitFunctionCall(FunctionCall node, Boolean unmangleNames) {
            StringBuilder builder = new StringBuilder("(");
            String name = node.getName().getSuffix();
            KsqlFunction ksqlFunction = this.functionRegistry.getFunction(name);
            String javaReturnType = SchemaUtil.getJavaType((Schema)ksqlFunction.getReturnType()).getSimpleName();
            builder.append("(" + javaReturnType + ") " + name + ".evaluate(");
            boolean addComma = false;
            for (Expression argExpr : node.getArguments()) {
                Pair processedArg = (Pair)this.process((Node)argExpr, unmangleNames);
                if (addComma) {
                    builder.append(" , ");
                } else {
                    addComma = true;
                }
                builder.append((String)processedArg.getLeft());
            }
            builder.append(")");
            builder.append(")");
            return new Pair((Object)builder.toString(), (Object)ksqlFunction.getReturnType());
        }

        protected Pair<String, Schema> visitLogicalBinaryExpression(LogicalBinaryExpression node, Boolean unmangleNames) {
            if (node.getType() == LogicalBinaryExpression.Type.OR) {
                return new Pair((Object)this.formatBinaryExpression(" || ", node.getLeft(), node.getRight(), unmangleNames), (Object)Schema.BOOLEAN_SCHEMA);
            }
            if (node.getType() == LogicalBinaryExpression.Type.AND) {
                return new Pair((Object)this.formatBinaryExpression(" && ", node.getLeft(), node.getRight(), unmangleNames), (Object)Schema.BOOLEAN_SCHEMA);
            }
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", ((Object)((Object)this)).getClass().getName(), node.getClass().getSimpleName()));
        }

        protected Pair<String, Schema> visitNotExpression(NotExpression node, Boolean unmangleNames) {
            String exprString = (String)((Pair)this.process((Node)node.getValue(), unmangleNames)).getLeft();
            return new Pair((Object)("(!" + exprString + ")"), (Object)Schema.BOOLEAN_SCHEMA);
        }

        private String nullCheckPrefix(ComparisonExpression.Type type) {
            switch (type) {
                case IS_DISTINCT_FROM: {
                    return "(((Object)%1$s) == null || ((Object)%2$s) == null) ? ((((Object)%1$s) == null ) ^ (((Object)%2$s) == null )) : ";
                }
            }
            return "(((Object)%1$s) == null || ((Object)%2$s) == null) ? false : ";
        }

        private String visitStringComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(%1$s.equals(%2$s))";
                }
                case IS_DISTINCT_FROM: 
                case NOT_EQUAL: {
                    return "(!%1$s.equals(%2$s))";
                }
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    return "(%1$s.compareTo(%2$s) " + type.getValue() + " 0)";
                }
            }
            throw new KsqlException("Unexpected string comparison: " + type.getValue());
        }

        private String visitScalarComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "((%1$s <= %2$s) && (%1$s >= %2$s))";
                }
                case IS_DISTINCT_FROM: 
                case NOT_EQUAL: {
                    return "((%1$s < %2$s) || (%1$s > %2$s))";
                }
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    return "(%1$s " + type.getValue() + " %2$s)";
                }
            }
            throw new KsqlException("Unexpected scalar comparison: " + type.getValue());
        }

        private String visitBooleanComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(Boolean.compare(%1$s, %2$s) == 0)";
                }
                case IS_DISTINCT_FROM: 
                case NOT_EQUAL: {
                    return "(Boolean.compare(%1$s, %2$s) != 0)";
                }
            }
            throw new KsqlException("Unexpected boolean comparison: " + type.getValue());
        }

        protected Pair<String, Schema> visitComparisonExpression(ComparisonExpression node, Boolean unmangleNames) {
            Pair left = (Pair)this.process((Node)node.getLeft(), unmangleNames);
            Pair right = (Pair)this.process((Node)node.getRight(), unmangleNames);
            String exprFormat = this.nullCheckPrefix(node.getType());
            switch (((Schema)left.getRight()).type()) {
                case STRING: {
                    exprFormat = exprFormat + this.visitStringComparisonExpression(node.getType());
                    break;
                }
                case MAP: {
                    throw new KsqlException("Cannot compare MAP values");
                }
                case ARRAY: {
                    throw new KsqlException("Cannot compare ARRAY values");
                }
                case BOOLEAN: {
                    exprFormat = exprFormat + this.visitBooleanComparisonExpression(node.getType());
                    break;
                }
                default: {
                    exprFormat = exprFormat + this.visitScalarComparisonExpression(node.getType());
                }
            }
            String expr = "(" + String.format(exprFormat, left.getLeft(), right.getLeft()) + ")";
            return new Pair((Object)expr, (Object)Schema.BOOLEAN_SCHEMA);
        }

        protected Pair<String, Schema> visitCast(Cast node, Boolean context) {
            Pair expr = (Pair)this.process((Node)node.getExpression(), context);
            String returnTypeStr = node.getType();
            Schema returnType = SchemaUtil.getTypeSchema((String)returnTypeStr);
            switch (returnTypeStr) {
                case "VARCHAR": 
                case "STRING": {
                    return new Pair((Object)("String.valueOf(" + (String)expr.getLeft() + ")"), (Object)returnType);
                }
                case "BOOLEAN": {
                    Schema rightSchema = (Schema)expr.getRight();
                    return new Pair((Object)this.getCastToBooleanString(rightSchema, (String)expr.getLeft()), (Object)returnType);
                }
                case "INTEGER": {
                    Schema rightSchema = (Schema)expr.getRight();
                    String exprStr = this.getCastString(rightSchema, (String)expr.getLeft(), "intValue", "Integer.parseInt");
                    return new Pair((Object)exprStr, (Object)returnType);
                }
                case "BIGINT": {
                    Schema rightSchema = (Schema)expr.getRight();
                    String exprStr = this.getCastString(rightSchema, (String)expr.getLeft(), "longValue", "Long.parseLong");
                    return new Pair((Object)exprStr, (Object)returnType);
                }
                case "DOUBLE": {
                    Schema rightSchema = (Schema)expr.getRight();
                    String exprStr = this.getCastString(rightSchema, (String)expr.getLeft(), "doubleValue", "Double.parseDouble");
                    return new Pair((Object)exprStr, (Object)returnType);
                }
            }
            throw new KsqlFunctionException("Invalid cast operation: " + returnTypeStr);
        }

        protected Pair<String, Schema> visitIsNullPredicate(IsNullPredicate node, Boolean unmangleNames) {
            Pair value = (Pair)this.process((Node)node.getValue(), unmangleNames);
            return new Pair((Object)("((" + (String)value.getLeft() + ") == null )"), (Object)Schema.BOOLEAN_SCHEMA);
        }

        protected Pair<String, Schema> visitIsNotNullPredicate(IsNotNullPredicate node, Boolean unmangleNames) {
            Pair value = (Pair)this.process((Node)node.getValue(), unmangleNames);
            return new Pair((Object)("((" + (String)value.getLeft() + ") != null )"), (Object)Schema.BOOLEAN_SCHEMA);
        }

        protected Pair<String, Schema> visitArithmeticUnary(ArithmeticUnaryExpression node, Boolean unmangleNames) {
            Pair value = (Pair)this.process((Node)node.getValue(), unmangleNames);
            switch (node.getSign()) {
                case MINUS: {
                    String separator = ((String)value.getLeft()).startsWith("-") ? " " : "";
                    return new Pair((Object)("-" + separator + (String)value.getLeft()), value.getRight());
                }
                case PLUS: {
                    return new Pair((Object)("+" + (String)value.getLeft()), value.getRight());
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + node.getSign());
        }

        protected Pair<String, Schema> visitArithmeticBinary(ArithmeticBinaryExpression node, Boolean unmangleNames) {
            Pair left = (Pair)this.process((Node)node.getLeft(), unmangleNames);
            Pair right = (Pair)this.process((Node)node.getRight(), unmangleNames);
            return new Pair((Object)("(" + (String)left.getLeft() + " " + node.getType().getValue() + " " + (String)right.getLeft() + ")"), (Object)Schema.FLOAT64_SCHEMA);
        }

        protected Pair<String, Schema> visitLikePredicate(LikePredicate node, Boolean unmangleNames) {
            String paternString = ((String)((Pair)this.process((Node)node.getPattern(), true)).getLeft()).substring(1);
            paternString = paternString.substring(0, paternString.length() - 1);
            String valueString = (String)((Pair)this.process((Node)node.getValue(), true)).getLeft();
            if (paternString.startsWith("%")) {
                if (paternString.endsWith("%")) {
                    return new Pair((Object)("(" + valueString + ").contains(\"" + paternString.substring(1, paternString.length() - 1) + "\")"), (Object)Schema.STRING_SCHEMA);
                }
                return new Pair((Object)("(" + valueString + ").endsWith(\"" + paternString.substring(1) + "\")"), (Object)Schema.STRING_SCHEMA);
            }
            if (paternString.endsWith("%")) {
                return new Pair((Object)("(" + valueString + ")" + ".startsWith(\"" + paternString.substring(0, paternString.length() - 1) + "\")"), (Object)Schema.STRING_SCHEMA);
            }
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitAllColumns(AllColumns node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitSubscriptExpression(SubscriptExpression node, Boolean unmangleNames) {
            String arrayBaseName = node.getBase().toString();
            Optional schemaField = SchemaUtil.getFieldByName((Schema)SqlToJavaVisitor.this.schema, (String)arrayBaseName);
            if (!schemaField.isPresent()) {
                throw new KsqlException("Field not found: " + arrayBaseName);
            }
            if (((Field)schemaField.get()).schema().type() == Schema.Type.ARRAY) {
                return new Pair((Object)((String)((Pair)this.process((Node)node.getBase(), unmangleNames)).getLeft() + "[(int)(" + (String)((Pair)this.process((Node)node.getIndex(), unmangleNames)).getLeft() + ")]"), (Object)SqlToJavaVisitor.this.schema);
            }
            if (((Field)schemaField.get()).schema().type() == Schema.Type.MAP) {
                return new Pair((Object)("(" + SchemaUtil.getJavaCastString((Schema)((Field)schemaField.get()).schema().valueSchema()) + (String)((Pair)this.process((Node)node.getBase(), unmangleNames)).getLeft() + ".get" + "(" + (String)((Pair)this.process((Node)node.getIndex(), unmangleNames)).getLeft() + "))"), (Object)SqlToJavaVisitor.this.schema);
            }
            throw new UnsupportedOperationException();
        }

        protected Pair<String, Schema> visitBetweenPredicate(BetweenPredicate node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right, boolean unmangleNames) {
            return "(" + (String)((Pair)this.process((Node)left, unmangleNames)).getLeft() + " " + operator + " " + (String)((Pair)this.process((Node)right, unmangleNames)).getLeft() + ")";
        }

        private String formatIdentifier(String s) {
            return s;
        }

        private String joinExpressions(List<Expression> expressions, boolean unmangleNames) {
            return Joiner.on((String)", ").join(expressions.stream().map(e -> (Pair)this.process((Node)e, unmangleNames)).iterator());
        }

        private String getCastToBooleanString(Schema schema, String exprStr) {
            if (schema.type() == Schema.Type.BOOLEAN) {
                return exprStr;
            }
            if (schema.type() == Schema.Type.STRING) {
                return "Boolean.parseBoolean(" + exprStr + ")";
            }
            throw new KsqlFunctionException("Invalid cast operation: Cannot cast " + exprStr + " to boolean.");
        }

        private String getCastString(Schema schema, String exprStr, String javaTypeMethod, String javaStringParserMethod) {
            switch (schema.type()) {
                case INT32: {
                    if (javaTypeMethod.equals("intValue")) {
                        return exprStr;
                    }
                    return "(new Integer(" + exprStr + ")." + javaTypeMethod + "())";
                }
                case INT64: {
                    if (javaTypeMethod.equals("longValue")) {
                        return exprStr;
                    }
                    return "(new Long(" + exprStr + ")." + javaTypeMethod + "())";
                }
                case FLOAT64: {
                    if (javaTypeMethod.equals("doubleValue")) {
                        return exprStr;
                    }
                    return "(new Double(" + exprStr + ")." + javaTypeMethod + "())";
                }
                case STRING: {
                    return javaStringParserMethod + "(" + exprStr + ")";
                }
            }
            throw new KsqlFunctionException("Invalid cast operation: Cannot cast " + exprStr + " to " + schema.type() + ".");
        }
    }
}

