/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.analyzer.AggregateAnalysis;
import io.confluent.ksql.analyzer.AggregateAnalyzer;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.AnalysisContext;
import io.confluent.ksql.analyzer.Analyzer;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.ExpressionRewriter;
import io.confluent.ksql.parser.tree.ExpressionTreeRewriter;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QuerySpecification;
import io.confluent.ksql.util.AggregateExpressionRewriter;
import io.confluent.ksql.util.KsqlException;

public class QueryAnalyzer {
    private final MetaStore metaStore;
    private final FunctionRegistry functionRegistry;

    public QueryAnalyzer(MetaStore metaStore, FunctionRegistry functionRegistry) {
        this.metaStore = metaStore;
        this.functionRegistry = functionRegistry;
    }

    public Analysis analyze(String sqlExpression, Query query) {
        Analysis analysis = new Analysis();
        Analyzer analyzer = new Analyzer(sqlExpression, analysis, this.metaStore);
        analyzer.process((Node)query, new AnalysisContext());
        return analysis;
    }

    public AggregateAnalysis analyzeAggregate(Query query, Analysis analysis) {
        AggregateAnalysis aggregateAnalysis = new AggregateAnalysis();
        AggregateAnalyzer aggregateAnalyzer = new AggregateAnalyzer(aggregateAnalysis, analysis, this.functionRegistry);
        AggregateExpressionRewriter aggregateExpressionRewriter = new AggregateExpressionRewriter(this.functionRegistry);
        this.processSelectExpressions(analysis, aggregateAnalysis, aggregateAnalyzer, aggregateExpressionRewriter);
        if (!aggregateAnalysis.getAggregateFunctionArguments().isEmpty() && analysis.getGroupByExpressions().isEmpty()) {
            throw new KsqlException("Aggregate query needs GROUP BY clause. query:" + query);
        }
        if (analysis.getHavingExpression() != null) {
            this.processHavingExpression(analysis, aggregateAnalysis, aggregateAnalyzer, aggregateExpressionRewriter);
        }
        this.enforceAggregateRules(query, aggregateAnalysis);
        return aggregateAnalysis;
    }

    private void processHavingExpression(Analysis analysis, AggregateAnalysis aggregateAnalysis, AggregateAnalyzer aggregateAnalyzer, AggregateExpressionRewriter aggregateExpressionRewriter) {
        aggregateAnalyzer.process((Node)analysis.getHavingExpression(), new AnalysisContext());
        if (!aggregateAnalyzer.isHasAggregateFunction()) {
            aggregateAnalysis.addNonAggResultColumns(analysis.getHavingExpression());
        }
        aggregateAnalysis.setHavingExpression(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)aggregateExpressionRewriter, (Expression)analysis.getHavingExpression()));
        aggregateAnalyzer.setHasAggregateFunction(false);
    }

    private void processSelectExpressions(Analysis analysis, AggregateAnalysis aggregateAnalysis, AggregateAnalyzer aggregateAnalyzer, AggregateExpressionRewriter aggregateExpressionRewriter) {
        for (Expression expression : analysis.getSelectExpressions()) {
            aggregateAnalyzer.process((Node)expression, new AnalysisContext());
            if (!aggregateAnalyzer.isHasAggregateFunction()) {
                aggregateAnalysis.addNonAggResultColumns(expression);
            }
            aggregateAnalysis.addFinalSelectExpression(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)aggregateExpressionRewriter, (Expression)expression));
            aggregateAnalyzer.setHasAggregateFunction(false);
        }
    }

    private void enforceAggregateRules(Query query, AggregateAnalysis aggregateAnalysis) {
        int groupBySize;
        if (!((QuerySpecification)query.getQueryBody()).getGroupBy().isPresent()) {
            return;
        }
        int numberOfNonAggProjections = aggregateAnalysis.getNonAggResultColumns().size();
        if (numberOfNonAggProjections != (groupBySize = ((GroupBy)((QuerySpecification)query.getQueryBody()).getGroupBy().get()).getGroupingElements().size())) {
            throw new KsqlException("Group by elements should match the SELECT expressions.");
        }
    }
}

