/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import io.confluent.ksql.KsqlEngine;
import io.confluent.ksql.analyzer.AggregateAnalysis;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.QueryAnalyzer;
import io.confluent.ksql.ddl.commands.DDLCommand;
import io.confluent.ksql.ddl.commands.DDLCommandFactory;
import io.confluent.ksql.ddl.commands.DDLCommandResult;
import io.confluent.ksql.metastore.KsqlStream;
import io.confluent.ksql.metastore.KsqlTopic;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.MetastoreUtil;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.parser.tree.AbstractStreamCreateStatement;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.DDLStatement;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.StringLiteral;
import io.confluent.ksql.physical.PhysicalPlanBuilder;
import io.confluent.ksql.planner.LogicalPlanner;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.util.AvroUtil;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.streams.StreamsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryEngine {
    private static final Logger log = LoggerFactory.getLogger(QueryEngine.class);
    private final KsqlEngine ksqlEngine;
    private final DDLCommandFactory ddlCommandFactory;

    QueryEngine(KsqlEngine ksqlEngine, DDLCommandFactory ddlCommandFactory) {
        this.ddlCommandFactory = ddlCommandFactory;
        this.ksqlEngine = ksqlEngine;
    }

    List<Pair<String, PlanNode>> buildLogicalPlans(MetaStore metaStore, List<Pair<String, Statement>> statementList) {
        ArrayList<Pair<String, PlanNode>> logicalPlansList = new ArrayList<Pair<String, PlanNode>>();
        MetaStore tempMetaStore = metaStore.clone();
        for (Pair<String, Statement> statementQueryPair : statementList) {
            if (statementQueryPair.getRight() instanceof Query) {
                PlanNode logicalPlan = this.buildQueryLogicalPlan((String)statementQueryPair.getLeft(), (Query)statementQueryPair.getRight(), tempMetaStore);
                logicalPlansList.add((Pair<String, PlanNode>)new Pair(statementQueryPair.getLeft(), (Object)logicalPlan));
            } else {
                logicalPlansList.add((Pair<String, PlanNode>)new Pair(statementQueryPair.getLeft(), null));
            }
            log.info("Build logical plan for {}.", statementQueryPair.getLeft());
        }
        return logicalPlansList;
    }

    private PlanNode buildQueryLogicalPlan(String sqlExpression, Query query, MetaStore tempMetaStore) {
        AggregateAnalysis aggAnalysis;
        QueryAnalyzer queryAnalyzer = new QueryAnalyzer(tempMetaStore, this.ksqlEngine.getFunctionRegistry());
        Analysis analysis = queryAnalyzer.analyze(sqlExpression, query);
        PlanNode logicalPlan = new LogicalPlanner(analysis, aggAnalysis = queryAnalyzer.analyzeAggregate(query, analysis), this.ksqlEngine.getFunctionRegistry()).buildPlan();
        if (logicalPlan instanceof KsqlStructuredDataOutputNode) {
            KsqlStructuredDataOutputNode ksqlStructuredDataOutputNode = (KsqlStructuredDataOutputNode)logicalPlan;
            KsqlStream structuredDataSource = new KsqlStream(sqlExpression, ksqlStructuredDataOutputNode.getId().toString(), ksqlStructuredDataOutputNode.getSchema(), ksqlStructuredDataOutputNode.getKeyField(), ksqlStructuredDataOutputNode.getTimestampField() == null ? ksqlStructuredDataOutputNode.getTheSourceNode().getTimestampField() : ksqlStructuredDataOutputNode.getTimestampField(), ksqlStructuredDataOutputNode.getKsqlTopic());
            tempMetaStore.putTopic(ksqlStructuredDataOutputNode.getKsqlTopic());
            tempMetaStore.putSource(structuredDataSource.cloneWithTimeKeyColumns());
        }
        return logicalPlan;
    }

    List<QueryMetadata> buildPhysicalPlans(List<Pair<String, PlanNode>> logicalPlans, List<Pair<String, Statement>> statementList, Map<String, Object> overriddenProperties, boolean updateMetastore) throws Exception {
        ArrayList<QueryMetadata> physicalPlans = new ArrayList<QueryMetadata>();
        for (int i = 0; i < logicalPlans.size(); ++i) {
            Pair<String, PlanNode> statementPlanPair = logicalPlans.get(i);
            if (statementPlanPair.getRight() == null) {
                Statement statement = (Statement)statementList.get(i).getRight();
                if (!(statement instanceof DDLStatement)) {
                    throw new KsqlException("expecting a statement implementing DDLStatement but got: " + statement.getClass());
                }
                this.handleDdlStatement((String)statementPlanPair.getLeft(), (DDLStatement)statement, overriddenProperties);
                continue;
            }
            this.buildQueryPhysicalPlan(physicalPlans, statementPlanPair, overriddenProperties, updateMetastore);
        }
        return physicalPlans;
    }

    private void buildQueryPhysicalPlan(List<QueryMetadata> physicalPlans, Pair<String, PlanNode> statementPlanPair, Map<String, Object> overriddenProperties, boolean updateMetastore) throws Exception {
        StreamsBuilder builder = new StreamsBuilder();
        PhysicalPlanBuilder physicalPlanBuilder = new PhysicalPlanBuilder(builder, this.ksqlEngine.getKsqlConfig().cloneWithPropertyOverwrite(overriddenProperties), this.ksqlEngine.getTopicClient(), new MetastoreUtil(), this.ksqlEngine.getFunctionRegistry(), overriddenProperties, updateMetastore, this.ksqlEngine.getMetaStore(), this.ksqlEngine.getSchemaRegistryClient());
        physicalPlans.add(physicalPlanBuilder.buildPhysicalPlan(statementPlanPair));
    }

    DDLCommandResult handleDdlStatement(String sqlExpression, DDLStatement statement, Map<String, Object> overriddenProperties) {
        AbstractStreamCreateStatement streamCreateStatement;
        Pair<DDLStatement, String> avroCheckResult;
        if (statement instanceof AbstractStreamCreateStatement && (avroCheckResult = this.maybeAddFieldsFromSchemaRegistry(streamCreateStatement = (AbstractStreamCreateStatement)statement)).getRight() != null) {
            statement = (DDLStatement)avroCheckResult.getLeft();
            sqlExpression = (String)avroCheckResult.getRight();
        }
        DDLCommand command = this.ddlCommandFactory.create(sqlExpression, statement, overriddenProperties);
        return this.ksqlEngine.getDDLCommandExec().execute(command);
    }

    StructuredDataSource getResultDatasource(Select select, String name) {
        SchemaBuilder dataSource = SchemaBuilder.struct().name(name);
        for (SelectItem selectItem : select.getSelectItems()) {
            if (!(selectItem instanceof SingleColumn)) continue;
            SingleColumn singleColumn = (SingleColumn)selectItem;
            String fieldName = (String)singleColumn.getAlias().get();
            dataSource = dataSource.field(fieldName, Schema.BOOLEAN_SCHEMA);
        }
        KsqlTopic ksqlTopic = new KsqlTopic(name, name, null);
        return new KsqlStream("QueryEngine-DDLCommand-Not-Needed", name, dataSource.schema(), null, null, ksqlTopic);
    }

    private Pair<DDLStatement, String> maybeAddFieldsFromSchemaRegistry(AbstractStreamCreateStatement streamCreateStatement) {
        Pair<AbstractStreamCreateStatement, String> avroCheckResult;
        if (streamCreateStatement.getProperties().containsKey("REGISTERED_TOPIC")) {
            String ksqlRegisteredTopicName = StringUtil.cleanQuotes(((Expression)streamCreateStatement.getProperties().get("REGISTERED_TOPIC")).toString().toUpperCase());
            KsqlTopic ksqlTopic = this.ksqlEngine.getMetaStore().getTopic(ksqlRegisteredTopicName);
            if (ksqlTopic == null) {
                throw new KsqlException(String.format("Could not find %s topic in the metastore.", ksqlRegisteredTopicName));
            }
            HashMap<String, StringLiteral> newProperties = new HashMap<String, StringLiteral>();
            newProperties.put("KAFKA_TOPIC", new StringLiteral(ksqlTopic.getKafkaTopicName()));
            newProperties.put("VALUE_FORMAT", new StringLiteral(ksqlTopic.getKsqlTopicSerDe().getSerDe().toString()));
            streamCreateStatement = streamCreateStatement.copyWith(streamCreateStatement.getElements(), newProperties);
        }
        if ((avroCheckResult = new AvroUtil().checkAndSetAvroSchema(streamCreateStatement, new HashMap<String, Object>(), this.ksqlEngine.getSchemaRegistryClient())).getRight() != null) {
            if (avroCheckResult.getLeft() instanceof CreateStream) {
                return new Pair((Object)((CreateStream)avroCheckResult.getLeft()), avroCheckResult.getRight());
            }
            if (avroCheckResult.getLeft() instanceof CreateTable) {
                return new Pair((Object)((CreateTable)avroCheckResult.getLeft()), avroCheckResult.getRight());
            }
        }
        return new Pair(null, null);
    }
}

