/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.KsqlEngine;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.MetaStoreImpl;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.KafkaTopicClientImpl;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlContext {
    private static final Logger log = LoggerFactory.getLogger(KsqlContext.class);
    private final KsqlEngine ksqlEngine;
    private static final String APPLICATION_ID_OPTION_DEFAULT = "ksql_standalone_cli";
    private static final String KAFKA_BOOTSTRAP_SERVER_OPTION_DEFAULT = "localhost:9092";
    private final AdminClient adminClient;
    private final KafkaTopicClient topicClient;

    public static KsqlContext create(KsqlConfig ksqlConfig) {
        return KsqlContext.create(ksqlConfig, null);
    }

    public static KsqlContext create(KsqlConfig ksqlConfig, SchemaRegistryClient schemaRegistryClient) {
        Map streamsProperties;
        if (ksqlConfig == null) {
            ksqlConfig = new KsqlConfig(Collections.emptyMap());
        }
        if (!(streamsProperties = ksqlConfig.getKsqlStreamConfigProps()).containsKey("application.id")) {
            streamsProperties.put("application.id", APPLICATION_ID_OPTION_DEFAULT);
        }
        AdminClient adminClient = AdminClient.create((Map)ksqlConfig.getKsqlAdminClientConfigProps());
        KafkaTopicClientImpl topicClient = new KafkaTopicClientImpl(adminClient, () -> ((KsqlConfig)ksqlConfig).getKsqlDefaultStream());
        if (schemaRegistryClient == null) {
            return new KsqlContext(adminClient, topicClient, new KsqlEngine(ksqlConfig, topicClient));
        }
        return new KsqlContext(adminClient, topicClient, new KsqlEngine(ksqlConfig, topicClient, schemaRegistryClient, (MetaStore)new MetaStoreImpl()));
    }

    KsqlContext(AdminClient adminClient, KafkaTopicClient topicClient, KsqlEngine ksqlEngine) {
        this.adminClient = adminClient;
        this.topicClient = topicClient;
        this.ksqlEngine = ksqlEngine;
    }

    public MetaStore getMetaStore() {
        return this.ksqlEngine.getMetaStore();
    }

    public void sql(String sql) throws Exception {
        List<QueryMetadata> queryMetadataList = this.ksqlEngine.buildMultipleQueries(sql, Collections.emptyMap());
        for (QueryMetadata queryMetadata : queryMetadataList) {
            if (queryMetadata instanceof PersistentQueryMetadata) {
                PersistentQueryMetadata persistentQueryMetadata = (PersistentQueryMetadata)queryMetadata;
                persistentQueryMetadata.getKafkaStreams().start();
                this.ksqlEngine.getPersistentQueries().put(persistentQueryMetadata.getId(), persistentQueryMetadata);
                continue;
            }
            System.err.println("Ignoring statemenst: " + sql);
            System.err.println("Only CREATE statements can run in KSQL embedded mode.");
            log.warn("Ignoring statemenst: {}", (Object)sql);
            log.warn("Only CREATE statements can run in KSQL embedded mode.");
        }
    }

    public Set<QueryMetadata> getRunningQueries() {
        return this.ksqlEngine.getLivePersistentQueries();
    }

    public void close() throws IOException {
        this.ksqlEngine.close();
        this.topicClient.close();
        this.adminClient.close();
    }
}

