/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class WelcomeMsgUtils {
    private WelcomeMsgUtils() {
    }

    public static void displayWelcomeMessage(int consoleWidth, PrintWriter writer) {
        String[] lines = new String[]{"", "===========================================", "=        _  __ _____  ____  _             =", "=       | |/ // ____|/ __ \\| |            =", "=       | ' /| (___ | |  | | |            =", "=       |  <  \\___ \\| |  | | |            =", "=       | . \\ ____) | |__| | |____        =", "=       |_|\\_\\_____/ \\___\\_\\______|       =", "=                                         =", "=  Streaming SQL Engine for Apache Kafka\u00ae =", "==========================================="};
        String copyrightMsg = "Copyright 2017 Confluent Inc.";
        Integer logoWidth = Arrays.stream(lines).map(String::length).reduce(0, Math::max);
        if (consoleWidth < logoWidth) {
            writer.println("KSQL, Copyright 2017 Confluent Inc.");
        } else {
            int paddingChars = (consoleWidth - logoWidth) / 2;
            String leftPadding = IntStream.range(0, paddingChars).mapToObj(idx -> " ").collect(Collectors.joining());
            Arrays.stream(lines).forEach(line -> writer.println(leftPadding + line));
            writer.println();
            writer.println("Copyright 2017 Confluent Inc.");
        }
        writer.println();
        writer.flush();
    }
}

