/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.KsqlException;
import java.net.ConnectException;
import java.util.Map;
import java.util.stream.Collectors;

public class CommonUtils {
    public static String getErrorMessageWithCause(Throwable e) {
        String msg = CommonUtils.getErrorMessage(e);
        String causeMsg = CommonUtils.getErrorCauseMessage(e);
        return causeMsg.isEmpty() ? msg : msg + "\r\n" + causeMsg;
    }

    public static String getErrorMessage(Throwable e) {
        if (e instanceof ConnectException) {
            return "Could not connect to the server.";
        }
        return e.getMessage();
    }

    public static String getErrorCauseMessage(Throwable e) {
        String prefix = "Caused by: ";
        String msg = "";
        for (e = e.getCause(); e != null; e = e.getCause()) {
            msg = msg + prefix + CommonUtils.getErrorMessage(e);
            prefix = "\r\n" + prefix;
        }
        return msg;
    }

    public static Map<String, Object> getPropertiesWithoutPrefix(String prefix, Map<String, Object> properties) {
        return properties.keySet().stream().filter(s -> !s.startsWith(prefix)).collect(Collectors.toMap(s -> s, s -> properties.get(s)));
    }

    public static String decorateTopicWithDefaultStreamIfNeeded(String topic, String defaultStream) {
        return topic.contains(":") ? topic : CommonUtils.decorateTopicWithDefaultStream(topic, defaultStream);
    }

    private static String decorateTopicWithDefaultStream(String topic, String defaultStream) {
        if (defaultStream.isEmpty()) {
            throw new KsqlException("Cannot decorate topic with default stream. Set ksql.default.stream");
        }
        return String.format("%s:%s", defaultStream, topic);
    }
}

