/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metrics;

import io.confluent.ksql.metrics.MetricCollector;
import io.confluent.ksql.metrics.TopicSensors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;

public class MetricCollectors {
    private static final Map<String, MetricCollector> collectorMap = new ConcurrentHashMap<String, MetricCollector>();
    private static Metrics metrics;
    private static io.confluent.common.utils.Time time;

    public static void initialize() {
        MetricConfig metricConfig = new MetricConfig().samples(100).timeWindow(1000L, TimeUnit.MILLISECONDS);
        ArrayList<JmxReporter> reporters = new ArrayList<JmxReporter>();
        reporters.add(new JmxReporter("io.confluent.ksql.metrics"));
        metrics = new Metrics(metricConfig, reporters, (Time)new SystemTime());
    }

    public static void cleanUp() {
        if (metrics != null) {
            metrics.close();
        }
        collectorMap.clear();
    }

    static String addCollector(String id, MetricCollector collector) {
        while (collectorMap.containsKey(id)) {
            id = id + "-" + collectorMap.size();
        }
        collectorMap.put(id, collector);
        return id;
    }

    static void remove(String id) {
        collectorMap.remove(id);
    }

    public static String getStatsFor(String topic, boolean isError) {
        ArrayList<TopicSensors.Stat> allStats = new ArrayList<TopicSensors.Stat>();
        collectorMap.values().forEach(c -> allStats.addAll(c.stats(topic.toLowerCase(), isError)));
        Map<String, TopicSensors.Stat> aggregateStats = MetricCollectors.getAggregateMetrics(allStats);
        return MetricCollectors.format(aggregateStats.values(), isError ? "last-failed" : "last-message");
    }

    public static void recordError(String topic) {
        collectorMap.values().iterator().next().recordError(topic);
    }

    static Map<String, TopicSensors.Stat> getAggregateMetrics(List<TopicSensors.Stat> allStats) {
        TreeMap<String, TopicSensors.Stat> results = new TreeMap<String, TopicSensors.Stat>();
        allStats.forEach(stat -> {
            results.computeIfAbsent(stat.name(), k -> new TopicSensors.Stat(stat.name(), 0.0, stat.getTimestamp()));
            ((TopicSensors.Stat)results.get(stat.name())).aggregate(stat.getValue());
        });
        return results;
    }

    private static String format(Collection<TopicSensors.Stat> stats, String lastEventTimestampMsg) {
        StringBuilder results = new StringBuilder();
        stats.forEach(stat -> results.append(stat.formatted()).append(" "));
        if (stats.size() > 0) {
            results.append(String.format("%16s: ", lastEventTimestampMsg)).append(String.format("%9s", stats.iterator().next().timestamp()));
        }
        return results.toString();
    }

    public static Collection<Double> currentConsumptionRateByQuery() {
        return collectorMap.values().stream().filter(collector -> collector.getGroupId() != null).collect(Collectors.groupingBy(MetricCollector::getGroupId, Collectors.summingDouble(MetricCollector::currentMessageConsumptionRate))).values();
    }

    public static double currentProductionRate() {
        return collectorMap.values().stream().mapToDouble(MetricCollector::currentMessageProductionRate).sum();
    }

    public static double currentConsumptionRate() {
        return collectorMap.values().stream().mapToDouble(MetricCollector::currentMessageConsumptionRate).sum();
    }

    public static double totalMessageConsumption() {
        return collectorMap.values().stream().mapToDouble(MetricCollector::totalMessageConsumption).sum();
    }

    public static double totalBytesConsumption() {
        return collectorMap.values().stream().mapToDouble(MetricCollector::totalBytesConsumption).sum();
    }

    public static double currentErrorRate() {
        return collectorMap.values().stream().mapToDouble(MetricCollector::errorRate).sum();
    }

    public static Metrics getMetrics() {
        return metrics;
    }

    public static io.confluent.common.utils.Time getTime() {
        return time;
    }

    static {
        MetricCollectors.initialize();
        time = new io.confluent.common.utils.SystemTime();
    }
}

