/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GenericRow {
    private final List<Object> columns;

    public GenericRow() {
        this.columns = new ArrayList<Object>();
    }

    public GenericRow(List<Object> columns) {
        Objects.requireNonNull(columns);
        this.columns = columns;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[ ");
        int currentIndex = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            Object obj = this.columns.get(i);
            if (obj == null) {
                stringBuilder.append("null");
            } else if (obj.getClass().isArray()) {
                stringBuilder.append(Arrays.toString((Object[])obj));
            } else if (obj instanceof String) {
                stringBuilder.append("'").append(obj).append("'");
            } else {
                stringBuilder.append(obj);
            }
            if (++currentIndex >= this.columns.size()) continue;
            stringBuilder.append(" | ");
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericRow that = (GenericRow)o;
        if (this.columns.size() != that.columns.size()) {
            return false;
        }
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public List<Object> getColumns() {
        return this.columns;
    }
}

