/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.streams.serdes.json.KafkaJsonSchemaSerde;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class KafkaJsonSchemaSerdeTest {
    private static final String ANY_TOPIC = "any-topic";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final String recordSchemaString = "{\"properties\": {\n     \"null\": {\"type\": \"null\"},\n     \"boolean\": {\"type\": \"boolean\"},\n     \"number\": {\"type\": \"number\"},\n     \"string\": {\"type\": \"string\"}\n  },\n  \"additionalProperties\": false\n}";
    private static final JsonSchema recordSchema = new JsonSchema("{\"properties\": {\n     \"null\": {\"type\": \"null\"},\n     \"boolean\": {\"type\": \"boolean\"},\n     \"number\": {\"type\": \"number\"},\n     \"string\": {\"type\": \"string\"}\n  },\n  \"additionalProperties\": false\n}");

    private Object createJsonRecord() throws IOException {
        String json = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"number\": 12,\n    \"string\": \"string\"\n}";
        return objectMapper.readValue(json, Object.class);
    }

    private SomeTestRecord createJsonRecordWithClass() throws IOException {
        String json = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"number\": 12,\n    \"string\": \"string\"\n}";
        return (SomeTestRecord)objectMapper.readValue(json, SomeTestRecord.class);
    }

    private static KafkaJsonSchemaSerde<Object> createConfiguredSerdeForRecordValues() {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        KafkaJsonSchemaSerde serde = new KafkaJsonSchemaSerde((SchemaRegistryClient)schemaRegistryClient);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    private static KafkaJsonSchemaSerde<SomeTestRecord> createConfiguredSerdeForRecordValuesWithClass() {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        KafkaJsonSchemaSerde serde = new KafkaJsonSchemaSerde((SchemaRegistryClient)schemaRegistryClient, SomeTestRecord.class);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    @Test
    public void shouldRoundTripRecords() throws Exception {
        KafkaJsonSchemaSerde<Object> serde = KafkaJsonSchemaSerdeTest.createConfiguredSerdeForRecordValues();
        Object record = this.createJsonRecord();
        Object roundtrippedRecord = serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, record));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.equalTo((Object)record));
        serde.close();
    }

    @Test
    public void shouldRoundTripNullRecordsToNull() {
        KafkaJsonSchemaSerde<Object> serde = KafkaJsonSchemaSerdeTest.createConfiguredSerdeForRecordValues();
        Object roundtrippedRecord = serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, null));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.nullValue());
        serde.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenInstantiatedWithNullSchemaRegistryClient() {
        new KafkaJsonSchemaSerde((SchemaRegistryClient)null);
    }

    @Test
    public void shouldLetTheAbilityToDeserializeToASpecificClass() throws IOException {
        KafkaJsonSchemaSerde<SomeTestRecord> serde = KafkaJsonSchemaSerdeTest.createConfiguredSerdeForRecordValuesWithClass();
        SomeTestRecord record = this.createJsonRecordWithClass();
        Object roundtrippedRecord = serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, (Object)record));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.equalTo((Object)record));
        serde.close();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SomeTestRecord {
        String string;
        Integer number;

        private SomeTestRecord() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SomeTestRecord that = (SomeTestRecord)o;
            return Objects.equals(this.string, that.string) && Objects.equals(this.number, that.number);
        }
    }
}

