/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.streams.serdes.avro.ConfigurationUtils;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationUtilsTest {
    @Test
    public void shouldEnableSpecificAvroWhenSettingIsMissing() {
        HashMap config = new HashMap();
        Map updatedConfig = ConfigurationUtils.withSpecificAvroEnabled(config);
        Assert.assertThat((Object)((Boolean)updatedConfig.get("specific.avro.reader")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldEnableSpecificAvroWhenSettingIsFalse() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("specific.avro.reader", false);
        Map updatedConfig = ConfigurationUtils.withSpecificAvroEnabled(config);
        Assert.assertThat((Object)((Boolean)updatedConfig.get("specific.avro.reader")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldEnableSpecificAvroWhenConfigIsNull() {
        Map updatedConfig = ConfigurationUtils.withSpecificAvroEnabled(null);
        Assert.assertThat((Object)((Boolean)updatedConfig.get("specific.avro.reader")), (Matcher)CoreMatchers.is((Object)true));
    }
}

