/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.streams.serdes.avro.PrimitiveAvroSerde;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PrimitiveAvroSerdeTest {
    private static final String ANY_TOPIC = "any-topic";

    private static <T> PrimitiveAvroSerde<T> createConfiguredSerdeForRecordValues() {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        PrimitiveAvroSerde serde = new PrimitiveAvroSerde((SchemaRegistryClient)schemaRegistryClient);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    @Test
    public void shouldRoundTripStringRecords() {
        PrimitiveAvroSerde stringSerde = PrimitiveAvroSerdeTest.createConfiguredSerdeForRecordValues();
        String stringRecord = "test";
        String roundTrippedRecord = (String)stringSerde.deserializer().deserialize(ANY_TOPIC, stringSerde.serializer().serialize(ANY_TOPIC, (Object)"test"));
        Assert.assertThat((Object)roundTrippedRecord, (Matcher)CoreMatchers.equalTo((Object)"test"));
        stringSerde.close();
    }

    @Test
    public void shouldRoundTripLongRecords() {
        PrimitiveAvroSerde longSerde = PrimitiveAvroSerdeTest.createConfiguredSerdeForRecordValues();
        Long longRecord = 50000L;
        Long roundTrippedLongRecord = (Long)longSerde.deserializer().deserialize(ANY_TOPIC, longSerde.serializer().serialize(ANY_TOPIC, (Object)longRecord));
        Assert.assertThat((Object)roundTrippedLongRecord, (Matcher)CoreMatchers.equalTo((Object)longRecord));
        longSerde.close();
    }

    @Test
    public void shouldRoundTripIntegerRecords() {
        PrimitiveAvroSerde integerSerde = PrimitiveAvroSerdeTest.createConfiguredSerdeForRecordValues();
        Integer intRecord = 50000;
        Integer roundTrippedIntegerRecord = (Integer)integerSerde.deserializer().deserialize(ANY_TOPIC, integerSerde.serializer().serialize(ANY_TOPIC, (Object)intRecord));
        Assert.assertThat((Object)roundTrippedIntegerRecord, (Matcher)CoreMatchers.equalTo((Object)intRecord));
        integerSerde.close();
    }

    @Test
    public void shouldRoundTripFloatRecords() {
        PrimitiveAvroSerde floatSerde = PrimitiveAvroSerdeTest.createConfiguredSerdeForRecordValues();
        Float floatRecord = Float.valueOf(50000.0f);
        Float roundTrippedFloatRecord = (Float)floatSerde.deserializer().deserialize(ANY_TOPIC, floatSerde.serializer().serialize(ANY_TOPIC, (Object)floatRecord));
        Assert.assertThat((Object)roundTrippedFloatRecord, (Matcher)CoreMatchers.equalTo((Object)floatRecord));
        floatSerde.close();
    }

    @Test
    public void shouldRoundTripDoubleRecords() {
        PrimitiveAvroSerde doubleSerde = PrimitiveAvroSerdeTest.createConfiguredSerdeForRecordValues();
        Double doubleRecord = 50000.0;
        Double roundTrippedDoubleRecord = (Double)doubleSerde.deserializer().deserialize(ANY_TOPIC, doubleSerde.serializer().serialize(ANY_TOPIC, (Object)doubleRecord));
        Assert.assertThat((Object)roundTrippedDoubleRecord, (Matcher)CoreMatchers.equalTo((Object)doubleRecord));
        doubleSerde.close();
    }

    @Test
    public void shouldRoundTripBooleanRecords() {
        PrimitiveAvroSerde booleanSerde = PrimitiveAvroSerdeTest.createConfiguredSerdeForRecordValues();
        Boolean booleanRecord = true;
        Boolean roundTrippedBooleanRecord = (Boolean)booleanSerde.deserializer().deserialize(ANY_TOPIC, booleanSerde.serializer().serialize(ANY_TOPIC, (Object)booleanRecord));
        Assert.assertThat((Object)roundTrippedBooleanRecord, (Matcher)CoreMatchers.equalTo((Object)booleanRecord));
        booleanSerde.close();
    }

    @Test
    public void shouldRoundTripNullRecordsToNull() {
        PrimitiveAvroSerde serde = PrimitiveAvroSerdeTest.createConfiguredSerdeForRecordValues();
        String roundtrippedRecord = (String)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, null));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.nullValue());
        serde.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenInstantiatedWithNullSchemaRegistryClient() {
        new PrimitiveAvroSerde(null);
    }
}

