/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.cel.avro;

import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroFieldType;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.pb.Checked;
import org.projectnessie.cel.common.types.ref.FieldType;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeDescription;

public final class AvroTypeDescription
implements TypeDescription {
    public static final Schema NULL_AVRO_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private final Schema schema;
    private final String fullName;
    private final Type type;
    private final com.google.api.expr.v1alpha1.Type pbType;
    private final Map<String, AvroFieldType> fieldTypes;

    AvroTypeDescription(Schema schema, TypeQuery typeQuery) {
        this.schema = schema;
        this.fullName = schema.getFullName();
        this.type = TypeT.newObjectTypeValue((String)this.fullName);
        this.pbType = com.google.api.expr.v1alpha1.Type.newBuilder().setMessageType(this.fullName).build();
        this.fieldTypes = new HashMap<String, AvroFieldType>();
        for (Schema.Field field : schema.getFields()) {
            String n = field.name();
            AvroFieldType ft = new AvroFieldType(this.findTypeForAvroType(field.schema(), typeQuery), target -> this.fromObject(target, n) != null, target -> this.fromObject(target, n), field.schema());
            this.fieldTypes.put(n, ft);
        }
    }

    com.google.api.expr.v1alpha1.Type findTypeForAvroType(Schema schema, TypeQuery typeQuery) {
        Schema.Type type = schema.getType();
        switch (type) {
            case BOOLEAN: {
                return Checked.checkedBool;
            }
            case INT: 
            case LONG: {
                return Checked.checkedInt;
            }
            case BYTES: 
            case FIXED: {
                return Checked.checkedBytes;
            }
            case FLOAT: 
            case DOUBLE: {
                return Checked.checkedDouble;
            }
            case STRING: {
                return Checked.checkedString;
            }
            case ARRAY: {
                return Checked.checkedListDyn;
            }
            case MAP: {
                return Checked.checkedMapStringDyn;
            }
            case ENUM: {
                return typeQuery.getType(schema);
            }
            case NULL: {
                return Checked.checkedNull;
            }
            case RECORD: {
                return typeQuery.getType(schema);
            }
            case UNION: {
                if (schema.getTypes().size() == 2 && schema.getTypes().contains(NULL_AVRO_SCHEMA)) {
                    for (Schema memberSchema : schema.getTypes()) {
                        if (memberSchema.equals((Object)NULL_AVRO_SCHEMA)) continue;
                        return this.findTypeForAvroType(memberSchema, typeQuery);
                    }
                }
                throw new IllegalArgumentException("Unsupported union type");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    boolean hasProperty(String property) {
        return this.fieldTypes.containsKey(property);
    }

    Object fromObject(Object value, String property) {
        Schema.Field f;
        AvroFieldType ft = this.fieldTypes.get(property);
        if (ft == null) {
            throw new IllegalArgumentException(String.format("No property named '%s'", property));
        }
        Schema schema = AvroTypeDescription.getSchema(value);
        GenericData data = AvroTypeDescription.getData(value);
        Object result = data.getField(value, (f = schema.getField(property)).name(), f.pos());
        if (result instanceof Utf8) {
            result = result.toString();
        }
        return result;
    }

    Type type() {
        return this.type;
    }

    com.google.api.expr.v1alpha1.Type pbType() {
        return this.pbType;
    }

    FieldType fieldType(String fieldName) {
        return this.fieldTypes.get(fieldName);
    }

    public String name() {
        return this.fullName;
    }

    public Class<?> reflectType() {
        try {
            return Class.forName(this.fullName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static Schema getSchema(Object message) {
        if (!(message instanceof GenericContainer)) {
            throw new IllegalArgumentException("Object is not a GenericContainer");
        }
        return ((GenericContainer)message).getSchema();
    }

    static GenericData getData(Object message) {
        if (message instanceof SpecificRecord) {
            return SpecificData.get();
        }
        if (message instanceof GenericRecord) {
            return GenericData.get();
        }
        return ReflectData.get();
    }

    @FunctionalInterface
    static interface TypeQuery {
        public com.google.api.expr.v1alpha1.Type getType(Schema var1);
    }
}

