/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.jsonata;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.util.Timestamps;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaInject;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaString;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rules.ExpiringSpecificWidget;
import io.confluent.kafka.schemaregistry.rules.ExpiringSpecificWidgetProto;
import io.confluent.kafka.schemaregistry.rules.NewSpecificWidget;
import io.confluent.kafka.schemaregistry.rules.NewWidgetProto;
import io.confluent.kafka.schemaregistry.rules.WidgetProto;
import io.confluent.kafka.schemaregistry.rules.jsonata.JsonataExecutor;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.junit.Assert;
import org.junit.Test;

public class JsonataExecutorTest {
    private final SchemaRegistryClient schemaRegistry;
    private final KafkaAvroSerializer avroSerializer;
    private final KafkaAvroDeserializer avroDeserializer;
    private final KafkaAvroSerializer reflectionAvroSerializer;
    private final KafkaAvroSerializer reflectionAvroSerializer2;
    private final KafkaAvroSerializer reflectionAvroSerializer3;
    private final KafkaAvroDeserializer reflectionAvroDeserializer;
    private final KafkaAvroDeserializer reflectionAvroDeserializer2;
    private final KafkaAvroDeserializer reflectionAvroDeserializer3;
    private final KafkaAvroDeserializer specificAvroDeserializer;
    private final KafkaProtobufSerializer<WidgetProto.Widget> protobufSerializer;
    private final KafkaProtobufSerializer<ExpiringSpecificWidgetProto.ExpiringSpecificWidget> protobufSerializer2;
    private final KafkaProtobufDeserializer<DynamicMessage> protobufDeserializer;
    private final KafkaProtobufDeserializer<NewWidgetProto.NewWidget> specificProtobufDeserializer;
    private final KafkaJsonSchemaSerializer<OldWidget> jsonSchemaSerializer;
    private final KafkaJsonSchemaSerializer<ExpiringWidget> jsonSchemaSerializer2;
    private final KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaDeserializer;
    private final KafkaJsonSchemaDeserializer<NewWidget> specificJsonSchemaDeserializer;
    private final String topic;
    private final UUID id = UUID.fromString("2182b6f9-6422-43d8-819e-822b2b678eec");

    public JsonataExecutorTest() {
        this.topic = "test";
        this.schemaRegistry = new MockSchemaRegistryClient((List)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()));
        HashMap<String, Object> defaultConfig = new HashMap<String, Object>();
        defaultConfig.put("schema.registry.url", "bogus");
        defaultConfig.put("auto.register.schemas", "false");
        defaultConfig.put("use.latest.version", "false");
        defaultConfig.put("use.latest.with.metadata", "application.version=v1");
        defaultConfig.put("avro.use.logical.type.converters", "true");
        defaultConfig.put("latest.compatibility.strict", "false");
        defaultConfig.put("rule.executors", "jsonata");
        defaultConfig.put("rule.executors.jsonata.class", JsonataExecutor.class);
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, defaultConfig);
        HashMap<String, String> defaultConfig2 = new HashMap<String, String>(defaultConfig);
        defaultConfig2.put("use.latest.with.metadata", "application.version=v2");
        this.avroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, defaultConfig2);
        HashMap<String, String> reflectionProps = new HashMap<String, String>(defaultConfig);
        reflectionProps.put("schema.reflection", "true");
        this.reflectionAvroSerializer = new KafkaAvroSerializer(this.schemaRegistry, reflectionProps);
        this.reflectionAvroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, reflectionProps);
        HashMap<String, String> reflectionProps2 = new HashMap<String, String>(reflectionProps);
        reflectionProps2.put("use.latest.with.metadata", "application.version=v2");
        this.reflectionAvroSerializer2 = new KafkaAvroSerializer(this.schemaRegistry, reflectionProps2);
        this.reflectionAvroDeserializer2 = new KafkaAvroDeserializer(this.schemaRegistry, reflectionProps2);
        HashMap<String, String> reflectionProps3 = new HashMap<String, String>(reflectionProps);
        reflectionProps3.put("use.latest.with.metadata", "application.version=v3");
        this.reflectionAvroSerializer3 = new KafkaAvroSerializer(this.schemaRegistry, reflectionProps3);
        this.reflectionAvroDeserializer3 = new KafkaAvroDeserializer(this.schemaRegistry, reflectionProps3);
        HashMap<String, String> specificProps2 = new HashMap<String, String>(defaultConfig2);
        specificProps2.put("specific.avro.reader", "true");
        this.specificAvroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, specificProps2);
        this.protobufSerializer = new KafkaProtobufSerializer(this.schemaRegistry, defaultConfig);
        this.protobufSerializer2 = new KafkaProtobufSerializer(this.schemaRegistry, defaultConfig);
        this.protobufDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, defaultConfig2);
        specificProps2.put("derive.type", "true");
        this.specificProtobufDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, specificProps2);
        this.jsonSchemaSerializer = new KafkaJsonSchemaSerializer(this.schemaRegistry, defaultConfig);
        this.jsonSchemaSerializer2 = new KafkaJsonSchemaSerializer(this.schemaRegistry, defaultConfig);
        this.jsonSchemaDeserializer = new KafkaJsonSchemaDeserializer(this.schemaRegistry, defaultConfig2, JsonNode.class);
        this.specificJsonSchemaDeserializer = new KafkaJsonSchemaDeserializer(this.schemaRegistry, specificProps2, NewWidget.class);
    }

    private Schema createNewGenericWidgetSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"NewGenericWidget\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"},{\"name\": \"height\", \"type\": \"int\"},{\"name\": \"version\", \"type\": \"int\"},{\"name\": \"id\", \"type\":{\"type\": \"string\", \"logicalType\": \"uuid\"}}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private Schema createExpiringWidgetSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"ExpiringWidget\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"},{\"name\": \"size\", \"type\": \"int\"},{\"name\": \"version\", \"type\": \"int\"},{\"name\": \"id\", \"type\":{\"type\": \"string\", \"logicalType\": \"uuid\"}},{\"name\": \"expiration\", \"type\":{\"type\": \"string\", \"logicalType\": \"date\"}}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    @Test
    public void testKafkaAvroSerializerGenericRecord() throws Exception {
        String ruleString = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        OldWidget widget = new OldWidget(this.id, "alice");
        widget.setSize(123);
        Schema schema = AvroSchemaUtils.getReflectData().getSchema(OldWidget.class);
        AvroSchema avroSchema = new AvroSchema(schema);
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        schema = this.createNewGenericWidgetSchema();
        avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.singletonList(rule), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)GenericRecord.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)123, (Object)((GenericRecord)obj).get("height"));
        Assert.assertEquals((Object)this.id, (Object)((GenericRecord)obj).get("id"));
    }

    @Test
    public void testKafkaAvroSerializerReflectionRecord() throws Exception {
        String ruleString = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        OldWidget widget = new OldWidget(this.id, "alice");
        widget.setSize(123);
        Schema schema = AvroSchemaUtils.getReflectData().getSchema(OldWidget.class);
        AvroSchema avroSchema = new AvroSchema(schema);
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        schema = AvroSchemaUtils.getReflectData().getSchema(NewWidget.class);
        avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.singletonList(rule), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer2.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)NewWidget.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (long)123L, (long)((NewWidget)obj).getHeight());
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecord() throws Exception {
        String ruleString = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        OldWidget widget = new OldWidget(this.id, "alice");
        widget.setSize(123);
        Schema schema = AvroSchemaUtils.getReflectData().getSchema(OldWidget.class);
        AvroSchema avroSchema = new AvroSchema(schema);
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        schema = NewSpecificWidget.getClassSchema();
        avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.singletonList(rule), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.specificAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)NewSpecificWidget.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (long)123L, (long)((NewSpecificWidget)((Object)obj)).getHeight());
    }

    @Test
    public void testKafkaAvroSerializerFullyCompatible() throws Exception {
        String rule1To2 = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        String rule2To1 = "$merge([$sift($, function($v, $k) {$k != 'height'}), {'size': $.'height'}])";
        String rule2To3 = "$merge([$sift($, function($v, $k) {$k != 'height'}), {'length': $.'height'}])";
        String rule3To2 = "$merge([$sift($, function($v, $k) {$k != 'length'}), {'height': $.'length'}])";
        OldWidget widget = new OldWidget(this.id, "alice");
        widget.setSize(123);
        Schema schema = AvroSchemaUtils.getReflectData().getSchema(OldWidget.class);
        AvroSchema avroSchema = new AvroSchema(schema);
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        schema = AvroSchemaUtils.getReflectData().getSchema(NewWidget.class);
        avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule1", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, rule1To2, null, null, false);
        Rule rule2 = new Rule("myRule2", null, RuleKind.TRANSFORM, RuleMode.DOWNGRADE, "JSONATA", null, null, rule2To1, null, null, false);
        RuleSet ruleSet = new RuleSet((List)ImmutableList.of((Object)rule, (Object)rule2), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        schema = AvroSchemaUtils.getReflectData().getSchema(NewerWidget.class);
        avroSchema = new AvroSchema(schema);
        rule = new Rule("myRule1", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, rule2To3, null, null, false);
        rule2 = new Rule("myRule2", null, RuleKind.TRANSFORM, RuleMode.DOWNGRADE, "JSONATA", null, null, rule3To2, null, null, false);
        ruleSet = new RuleSet((List)ImmutableList.of((Object)rule, (Object)rule2), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v3");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        this.deserializeWithAllVersions(bytes);
        NewWidget newWidget = new NewWidget(this.id, "alice");
        newWidget.setHeight(123);
        bytes = this.reflectionAvroSerializer2.serialize(this.topic, (Object)newWidget);
        this.deserializeWithAllVersions(bytes);
        NewerWidget newerWidget = new NewerWidget(this.id, "alice");
        newerWidget.setLength(123);
        bytes = this.reflectionAvroSerializer3.serialize(this.topic, (Object)newerWidget);
        this.deserializeWithAllVersions(bytes);
    }

    private void deserializeWithAllVersions(byte[] bytes) {
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a OldWidget", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a OldWidget", (long)123L, (long)((OldWidget)obj).getSize());
        obj = this.reflectionAvroDeserializer2.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)NewWidget.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (long)123L, (long)((NewWidget)obj).getHeight());
        obj = this.reflectionAvroDeserializer3.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewerWidget", (boolean)NewerWidget.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewerWidget", (long)123L, (long)((NewerWidget)obj).getLength());
    }

    @Test
    public void testKafkaAvroCondition() throws Exception {
        String ruleString = "$.expiration * 86400000 > $millis()";
        ExpiringSpecificWidget widget = new ExpiringSpecificWidget();
        widget.setName("alice");
        widget.setSize(123);
        widget.setExpiration(LocalDate.now());
        Schema schema = ExpiringSpecificWidget.getClassSchema();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)widget));
    }

    @Test
    public void testKafkaProtobufSerializerGeneric() throws Exception {
        String ruleString = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").setMybytes(ByteString.EMPTY).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        protobufSchema = protobufSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        protobufSchema = new ProtobufSchema(NewWidgetProto.NewWidget.getDescriptor());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.singletonList(rule), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        protobufSchema = protobufSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)123, (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("height")));
    }

    @Test
    public void testKafkaProtobufSerializerSpecific() throws Exception {
        String ruleString = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").setMybytes(ByteString.EMPTY).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        protobufSchema = protobufSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        protobufSchema = new ProtobufSchema(NewWidgetProto.NewWidget.getDescriptor());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.singletonList(rule), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        protobufSchema = protobufSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.specificProtobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)NewWidgetProto.NewWidget.class.isInstance(obj));
        NewWidgetProto.NewWidget newWidget = (NewWidgetProto.NewWidget)obj;
        Assert.assertEquals((String)"Returned object should be a NewWidget", (long)123L, (long)newWidget.getHeight());
    }

    @Test
    public void testKafkaProtobufCondition() throws Exception {
        String ruleString = "$toMillis($.expiration) > $millis()";
        ExpiringSpecificWidgetProto.ExpiringSpecificWidget widget = ExpiringSpecificWidgetProto.ExpiringSpecificWidget.newBuilder().setName("alice").setSize(123).setExpiration(Timestamps.fromMillis((long)System.currentTimeMillis())).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        protobufSchema = protobufSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        Assert.assertThrows(SerializationException.class, () -> this.protobufSerializer2.serialize(this.topic, (Message)widget));
    }

    @Test
    public void testKafkaJsonSerializerGeneric() throws Exception {
        String ruleString = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        OldWidget widget = new OldWidget(this.id, "alice");
        widget.setSize(123);
        JsonSchema jsonSchema = JsonSchemaUtils.getSchema((Object)widget);
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        jsonSchema = jsonSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        NewWidget newWidget = new NewWidget(this.id, "alice");
        jsonSchema = JsonSchemaUtils.getSchema((Object)newWidget);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.singletonList(rule), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        jsonSchema = jsonSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (long)123L, (long)((JsonNode)obj).get("height").intValue());
    }

    @Test
    public void testKafkaJsonSerializerSpecific() throws Exception {
        String ruleString = "$merge([$sift($, function($v, $k) {$k != 'size'}), {'height': $.'size'}])";
        OldWidget widget = new OldWidget(this.id, "alice");
        widget.setSize(123);
        JsonSchema jsonSchema = JsonSchemaUtils.getSchema((Object)widget);
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        jsonSchema = jsonSchema.copy(metadata, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        NewWidget newWidget = new NewWidget(this.id, "alice");
        jsonSchema = JsonSchemaUtils.getSchema((Object)newWidget);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.UPGRADE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.singletonList(rule), Collections.emptyList());
        props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v2");
        metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        jsonSchema = jsonSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.specificJsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a NewWidget", (boolean)NewWidget.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (long)123L, (long)((NewWidget)obj).getHeight());
    }

    @Test
    public void testKafkaJsonCondition() throws Exception {
        String ruleString = "$toMillis($.expiration) > $millis()";
        ExpiringWidget widget = new ExpiringWidget();
        widget.setName("alice");
        widget.setSize(123);
        widget.setExpiration(LocalDate.now());
        JsonSchema jsonSchema = JsonSchemaUtils.getSchema((Object)widget);
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITE, "JSONATA", null, null, ruleString, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        ImmutableSortedMap props = ImmutableSortedMap.of((Comparable)((Object)"application.version"), (Object)"v1");
        Metadata metadata = new Metadata(Collections.emptySortedMap(), (Map)props, Collections.emptySortedSet());
        jsonSchema = jsonSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        Assert.assertThrows(SerializationException.class, () -> this.jsonSchemaSerializer2.serialize(this.topic, (Object)widget));
    }

    @JsonSchemaInject(strings={@JsonSchemaString(path="javaType", value="io.confluent.kafka.schemaregistry.rules.jsonata.JsonataExecutorTest$ExpiringWidget")})
    public static class ExpiringWidget {
        private UUID id;
        private String name;
        private int size;
        private int version;
        private LocalDate expiration;

        public ExpiringWidget() {
        }

        public ExpiringWidget(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public LocalDate getExpiration() {
            return this.expiration;
        }

        public void setExpiration(LocalDate expiration) {
            this.expiration = expiration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpiringWidget widget = (ExpiringWidget)o;
            return this.name.equals(widget.name) && this.size == widget.size && this.version == widget.version && Objects.equals(this.id, widget.id) && Objects.equals(this.expiration, widget.expiration);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.size, this.version, this.expiration);
        }
    }

    @JsonSchemaInject(strings={@JsonSchemaString(path="javaType", value="io.confluent.kafka.schemaregistry.rules.jsonata.JsonataExecutorTest$NewerWidget")})
    public static class NewerWidget {
        private UUID id;
        private String name;
        private int length;
        private int version;

        public NewerWidget() {
        }

        public NewerWidget(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NewerWidget widget = (NewerWidget)o;
            return this.name.equals(widget.name) && this.length == widget.length && this.version == widget.version && Objects.equals(this.id, widget.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.length, this.version);
        }
    }

    @JsonSchemaInject(strings={@JsonSchemaString(path="javaType", value="io.confluent.kafka.schemaregistry.rules.jsonata.JsonataExecutorTest$NewWidget")})
    public static class NewWidget {
        private UUID id;
        private String name;
        private int height;
        private int version;

        public NewWidget() {
        }

        public NewWidget(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NewWidget widget = (NewWidget)o;
            return this.name.equals(widget.name) && this.height == widget.height && this.version == widget.version && Objects.equals(this.id, widget.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.height, this.version);
        }
    }

    @JsonSchemaInject(strings={@JsonSchemaString(path="javaType", value="io.confluent.kafka.schemaregistry.rules.jsonata.JsonataExecutorTest$OldWidget")})
    public static class OldWidget {
        private UUID id;
        private String name;
        private int size;
        private int version;

        public OldWidget() {
        }

        public OldWidget(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldWidget widget = (OldWidget)o;
            return this.name.equals(widget.name) && this.size == widget.size && this.version == widget.version && Objects.equals(this.id, widget.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.size, this.version);
        }
    }
}

