/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.cel.builtin;

import io.confluent.kafka.schemaregistry.rules.cel.builtin.BuiltinOverload;
import java.util.UUID;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;

public class BuiltinLibraryTest {
    private static final String THERE_IS_NO_PLACE_LIKE = "127.0.0.1";
    private static final String IPV6_ADDR = "2001:db8:85a3:0:0:8a2e:370:7334";

    @Test
    public void emailFailure() {
        BuiltinLibraryTest.assertFailure("a.@b.com", BuiltinOverload::validateEmail);
    }

    @Test
    public void emailSuccess() {
        BuiltinLibraryTest.assertSuccess("a@b.com", BuiltinOverload::validateEmail);
    }

    @Test
    public void hostnameLengthFailure() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 256; ++i) {
            sb.append('a');
        }
        String subject = sb.toString();
        BuiltinLibraryTest.assertFailure(subject, BuiltinOverload::validateHostname);
    }

    @Test
    public void hostnameSuccess() {
        BuiltinLibraryTest.assertSuccess("localhost", BuiltinOverload::validateHostname);
    }

    @Test
    public void hostnameWithUnderscoresFailure() {
        BuiltinLibraryTest.assertFailure("not_a_valid_host_name", BuiltinOverload::validateHostname);
    }

    @Test
    public void ipv4Failure() {
        BuiltinLibraryTest.assertFailure("asd", BuiltinOverload::validateIpv4);
    }

    @Test
    public void ipv4LengthFailure() {
        BuiltinLibraryTest.assertFailure(IPV6_ADDR, BuiltinOverload::validateIpv4);
    }

    @Test
    public void ipv4Success() {
        BuiltinLibraryTest.assertSuccess(THERE_IS_NO_PLACE_LIKE, BuiltinOverload::validateIpv4);
    }

    @Test
    public void ipv6Failure() {
        BuiltinLibraryTest.assertFailure("asd", BuiltinOverload::validateIpv6);
    }

    @Test
    public void ipv6LengthFailure() {
        BuiltinLibraryTest.assertFailure(THERE_IS_NO_PLACE_LIKE, BuiltinOverload::validateIpv6);
    }

    @Test
    public void ipv6Success() {
        BuiltinLibraryTest.assertSuccess(IPV6_ADDR, BuiltinOverload::validateIpv6);
    }

    @Test
    public void uriFailure() {
        BuiltinLibraryTest.assertFailure("12 34", BuiltinOverload::validateUri);
    }

    @Test
    public void relativeUriFails() {
        BuiltinLibraryTest.assertFailure("//example.com", BuiltinOverload::validateUri);
    }

    @Test
    public void relativeUriRefFails() {
        BuiltinLibraryTest.assertFailure("abc", BuiltinOverload::validateUri);
    }

    @Test
    public void uriSuccess() {
        BuiltinLibraryTest.assertSuccess("http://example.org:8080/example.html", BuiltinOverload::validateUri);
    }

    @Test
    public void uriRefSuccess() {
        BuiltinLibraryTest.assertSuccess("http://foo.bar/?baz=qux#quux", BuiltinOverload::validateUriRef);
    }

    @Test
    public void relativeUriRefSuccess() {
        BuiltinLibraryTest.assertSuccess("//foo.bar/?baz=qux#quux", BuiltinOverload::validateUriRef);
    }

    @Test
    public void pathSuccess() {
        BuiltinLibraryTest.assertSuccess("/abc", BuiltinOverload::validateUriRef);
    }

    @Test
    public void illegalCharFailure() {
        BuiltinLibraryTest.assertFailure("\\\\WINDOWS\\fileshare", BuiltinOverload::validateUriRef);
    }

    @Test
    public void uuidFailure() {
        BuiltinLibraryTest.assertFailure("97cd-6e3d1bc14494", BuiltinOverload::validateUuid);
    }

    @Test
    public void uuidSuccess() {
        System.out.println(UUID.randomUUID());
        BuiltinLibraryTest.assertSuccess("fa02a430-892f-4160-97cd-6e3d1bc14494", BuiltinOverload::validateUuid);
    }

    static void assertSuccess(String input, Predicate<String> format) {
        Assert.assertTrue((boolean)format.test(input));
    }

    static void assertFailure(String input, Predicate<String> format) {
        Assert.assertFalse((boolean)format.test(input));
    }
}

