/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import java.lang.ref.SoftReference;

public class LazyParsedSchemaHolder
implements ParsedSchemaHolder {
    private KafkaSchemaRegistry schemaRegistry;
    private SchemaKey schemaKey;
    private SoftReference<SchemaValue> schemaValueRef;

    public LazyParsedSchemaHolder(KafkaSchemaRegistry schemaRegistry, SchemaKey schemaKey) {
        this.schemaRegistry = schemaRegistry;
        this.schemaKey = schemaKey;
        this.schemaValueRef = new SoftReference<Object>(null);
    }

    public ParsedSchema schema() {
        try {
            return this.schemaRegistry.parseSchema(this.schemaValue().toSchemaEntity());
        }
        catch (SchemaRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    public SchemaValue schemaValue() throws SchemaRegistryException {
        SchemaValue schemaValue = this.schemaValueRef.get();
        if (schemaValue == null) {
            schemaValue = this.schemaRegistry.getSchemaValue(this.schemaKey);
            this.schemaValueRef = new SoftReference<SchemaValue>(schemaValue);
        }
        return schemaValue;
    }

    public void clear() {
        this.schemaValueRef.clear();
    }
}

