/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.storage.KafkaStoreMessageHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import org.junit.Assert;
import org.junit.Test;

public class SchemaValuesTest {
    @Test
    public void testSchemaValueDeserializeForMagicByte0() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(0);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\"}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        this.assertSchemaValue(subject, version, 1, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1067572235\",\"type\":\"string\"}]}", "AVRO", false, schemaValue);
    }

    @Test
    public void testSchemaValueDeserializeForMagicByte1WithDeleteFlagFalse() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(1);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":false}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        this.assertSchemaValue(subject, version, 1, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1067572235\",\"type\":\"string\"}]}", "AVRO", false, schemaValue);
    }

    @Test
    public void testSchemaValueDeserializeForMagicByte1WithDeleteFlagTrue() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(1);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":true}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        this.assertSchemaValue(subject, version, 1, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1067572235\",\"type\":\"string\"}]}", "AVRO", true, schemaValue);
    }

    @Test
    public void testSchemaValueDeserializeForUnSupportedMagicByte() {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(2);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":true}";
        try {
            serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
            Assert.fail((String)"Deserialization shouldn't be supported");
        }
        catch (SerializationException e) {
            Assert.assertEquals((Object)"Can't deserialize schema for the magic byte 2", (Object)e.getMessage());
        }
    }

    @Test
    public void testSchemaValueDeserializeForOffsetTimestamp() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(1);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":true,\"offset\":1,\"ts\":123}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        Assert.assertEquals((long)1L, (long)schemaValue.getOffset());
        Assert.assertEquals((long)123L, (long)schemaValue.getTimestamp());
    }

    @Test
    public void testSchemaValueCanonicalize() {
        String oldSchema = "syntax = \"proto3\";\npackage com.mycorp.mynamespace;\n\n// Test Comment.\r\nmessage value {\n  int32 myField1 = 1;\n}\n";
        String newSchema = "syntax = \"proto3\";\npackage com.mycorp.mynamespace;\n\nmessage value {\n  int32 myField1 = 1;\n}\n";
        SchemaValue schemaValue = new SchemaValue("sub", Integer.valueOf(1), Integer.valueOf(0), "PROTOBUF", null, oldSchema, false);
        KafkaStoreMessageHandler.canonicalize((SchemaProvider)new ProtobufSchemaProvider(), (SchemaValue)schemaValue);
        Assert.assertEquals((Object)newSchema, (Object)schemaValue.getSchema());
    }

    private void assertSchemaValue(String subject, int version, int schemaId, String schema, String type, boolean deleted, SchemaValue schemaValue) {
        Assert.assertNotNull((String)"Not Null", (Object)schemaValue);
        Assert.assertEquals((String)"Subject Matches", (Object)subject, (Object)schemaValue.getSubject());
        Assert.assertEquals((String)"Version matches", (Object)version, (Object)schemaValue.getVersion());
        Assert.assertEquals((String)"SchemaId matches", (Object)schemaId, (Object)schemaValue.getId());
        Assert.assertEquals((String)"Schema Matches", (Object)schema, (Object)schemaValue.getSchema());
        Assert.assertEquals((String)"Type matches", (Object)type, (Object)schemaValue.getSchemaType());
        Assert.assertEquals((String)"Delete Flag Matches", (Object)deleted, (Object)schemaValue.isDeleted());
    }
}

