/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.id;

import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalIdGenerator
implements IdGenerator {
    Logger log = LoggerFactory.getLogger(IncrementalIdGenerator.class);
    private final SchemaRegistry schemaRegistry;
    private final Map<String, Integer> maxIds = new ConcurrentHashMap<String, Integer>();

    public IncrementalIdGenerator(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @Override
    public int id(SchemaValue schema) throws IdGenerationException {
        String context = QualifiedSubject.contextFor((String)this.schemaRegistry.tenant(), (String)schema.getSubject());
        return this.maxIds.compute(context, (k, v) -> v != null ? v + 1 : 1);
    }

    @Override
    public int getMaxId(SchemaValue schema) {
        String context = QualifiedSubject.contextFor((String)this.schemaRegistry.tenant(), (String)schema.getSubject());
        return this.maxIds.computeIfAbsent(context, k -> 1);
    }

    @Override
    public void configure(SchemaRegistryConfig config) {
    }

    @Override
    public void init() throws IdGenerationException {
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue) {
        String context = QualifiedSubject.contextFor((String)this.schemaRegistry.tenant(), (String)schemaKey.getSubject());
        this.maxIds.compute(context, (k, v) -> {
            int id = v != null ? v : 1;
            return Math.max(schemaValue.getId(), id);
        });
    }
}

