/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;

public class VersionId {
    private final int version;

    public VersionId(String version) throws InvalidVersionException {
        if (version.trim().toLowerCase().equals("latest")) {
            this.version = -1;
        } else {
            try {
                this.version = Integer.parseInt(version.trim());
            }
            catch (NumberFormatException nfe) {
                throw new InvalidVersionException(version);
            }
            this.assertValidVersion();
        }
    }

    public VersionId(int version) throws InvalidVersionException {
        this.version = version;
        this.assertValidVersion();
    }

    public int getVersionId() {
        return this.version;
    }

    public boolean isLatest() {
        return this.version == -1;
    }

    private void assertValidVersion() throws InvalidVersionException {
        if (this.version <= 0 && this.version != -1) {
            throw new InvalidVersionException(String.valueOf(this.version));
        }
    }
}

