/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.util;

import io.confluent.kafka.schemaregistry.util.ByteProducerPool;
import io.confluent.kafka.schemaregistry.util.KafkaClientSupplier;
import io.confluent.kafka.schemaregistry.utils.UserGroupInformationMockPolicy;
import io.confluent.rest.exceptions.RestServerErrorException;
import io.confluent.rest.impersonation.Errors;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@MockPolicy(value={UserGroupInformationMockPolicy.class})
public class ByteProducerPoolTest
extends EasyMockSupport {
    private static final byte[] ANY_BYTES = "text".getBytes();
    private static final ProducerRecord<byte[], byte[]> ANY_RECORD = new ProducerRecord("topic", (Object)ANY_BYTES);
    private Map<String, Object> producerConfig = new HashMap<String, Object>();
    private KafkaClientSupplier clientSupplier;
    private ByteProducerPool producerPool;
    private IdMappingServiceProvider idMapper;

    @Before
    public void setUp() {
        this.clientSupplier = (KafkaClientSupplier)this.mock(KafkaClientSupplier.class);
        this.idMapper = (IdMappingServiceProvider)this.mock(IdMappingServiceProvider.class);
        this.producerPool = new ByteProducerPool(this.producerConfig, this.clientSupplier, this.idMapper);
    }

    @Test
    public void sendsRecordByCreatedProducer() throws IOException {
        CompletableFuture expectedFuture = new CompletableFuture();
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        EasyMock.expect((Object)this.idMapper.getUid(currentUser.getUserName())).andReturn((Object)1000);
        KafkaProducer<byte[], byte[]> producer = this.mockProducerFor(currentUser);
        EasyMock.expect((Object)producer.send(ANY_RECORD)).andReturn(expectedFuture);
        this.replayAll();
        Future result = this.producerPool.send(ANY_RECORD);
        Assert.assertSame(expectedFuture, (Object)result);
        this.verifyAll();
    }

    @Test
    public void cachesProducerByUser() throws IOException {
        CompletableFuture expectedForU1C1 = new CompletableFuture();
        CompletableFuture expectedForU1C2 = new CompletableFuture();
        CompletableFuture expectedForU2C1 = new CompletableFuture();
        UserGroupInformation u1 = UserGroupInformation.createRemoteUser((String)"U1");
        EasyMock.expect((Object)this.idMapper.getUid(u1.getUserName())).andReturn((Object)1001).times(2);
        UserGroupInformation u2 = UserGroupInformation.createRemoteUser((String)"U2");
        EasyMock.expect((Object)this.idMapper.getUid(u2.getUserName())).andReturn((Object)1002);
        KafkaProducer<byte[], byte[]> producerForU1 = this.mockProducerFor(u1);
        KafkaProducer<byte[], byte[]> producerForU2 = this.mockProducerFor(u2);
        EasyMock.expect((Object)producerForU1.send(ANY_RECORD)).andReturn(expectedForU1C1).andReturn(expectedForU1C2);
        EasyMock.expect((Object)producerForU2.send(ANY_RECORD)).andReturn(expectedForU2C1);
        this.replayAll();
        PrivilegedAction<Future> sendAnyRecord = () -> this.producerPool.send(ANY_RECORD);
        Assert.assertThat((Object)((Future)u1.doAs(sendAnyRecord)), (Matcher)CoreMatchers.is(expectedForU1C1));
        Assert.assertThat((Object)((Future)u2.doAs(sendAnyRecord)), (Matcher)CoreMatchers.is(expectedForU2C1));
        Assert.assertThat((Object)((Future)u1.doAs(sendAnyRecord)), (Matcher)CoreMatchers.is(expectedForU1C2));
        this.verifyAll();
    }

    private KafkaProducer<byte[], byte[]> mockProducerFor(UserGroupInformation user) {
        KafkaProducer producer = (KafkaProducer)this.mock(KafkaProducer.class);
        EasyMock.expect((Object)this.clientSupplier.getProducer(this.producerConfig)).andAnswer(() -> {
            Assert.assertThat((String)"Should be created by another user", (Object)UserGroupInformation.getCurrentUser(), (Matcher)CoreMatchers.is((Object)user));
            return producer;
        }).once();
        return producer;
    }

    @Test
    public void throwsServerLoginExceptionOnFailure() throws IOException {
        RuntimeException cause = new RuntimeException("Somehow cannot create producer");
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        EasyMock.expect((Object)this.idMapper.getUid(currentUser.getUserName())).andReturn((Object)1000);
        KafkaProducer<byte[], byte[]> producer = this.mockProducerFor(currentUser);
        EasyMock.expect((Object)producer.send((ProducerRecord)EasyMock.anyObject())).andThrow((Throwable)cause);
        this.replayAll();
        try {
            this.producerPool.send(ANY_RECORD);
            Assert.fail();
        }
        catch (RestServerErrorException e) {
            RestServerErrorException expected = Errors.serverLoginException((Throwable)cause);
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Object)expected.getCause()));
            Assert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)expected.getErrorCode()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)expected.getMessage()));
        }
        this.verifyAll();
    }

    @Test
    public void closesCachedProducer() throws IOException {
        CompletableFuture expectedFuture = new CompletableFuture();
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        EasyMock.expect((Object)this.idMapper.getUid(currentUser.getUserName())).andReturn((Object)1000);
        KafkaProducer<byte[], byte[]> producer = this.mockProducerFor(currentUser);
        EasyMock.expect((Object)producer.send(ANY_RECORD)).andReturn(expectedFuture);
        producer.close();
        EasyMock.expectLastCall().once();
        this.replayAll();
        this.producerPool.send(ANY_RECORD);
        this.producerPool.close();
        this.verifyAll();
    }
}

