/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.confluent.kafka.schemaregistry.util.ByteProducerPool;
import io.confluent.kafka.schemaregistry.util.KafkaClientSupplier;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.apache.hadoop.security.ShellBasedIdMapping;
import org.apache.kafka.common.KafkaException;

public class UnixUserIdUtils {
    private static final java.util.function.Supplier<IdMappingServiceProvider> LAZY_UNIX_ID_MAPPER = () -> ((Supplier)Suppliers.memoize(UnixUserIdUtils::createShellBasedIdMapping)).get();

    private static ShellBasedIdMapping createShellBasedIdMapping() {
        try {
            return new ShellBasedIdMapping(new Configuration());
        }
        catch (IOException e) {
            throw new KafkaException("Cannot initialize ShellBasedIdMapping mapper");
        }
    }

    public static IdMappingServiceProvider getUnixIdMapper() {
        return LAZY_UNIX_ID_MAPPER.get();
    }

    public static ByteProducerPool configureProducerPool(Properties properties) {
        Map<String, Object> config = properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue));
        KafkaClientSupplier clientSupplier = new KafkaClientSupplier();
        IdMappingServiceProvider unixIdMapper = UnixUserIdUtils.getUnixIdMapper();
        return new ByteProducerPool(config, clientSupplier, unixIdMapper);
    }
}

