/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.filter.Permission;
import io.confluent.kafka.schemaregistry.filter.RequirePermission;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.impersonation.ImpersonationUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SchemasResource {
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public SchemasResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @Path(value="/ids/{id}")
    @ApiOperation(value="Get the schema string identified by the input ID.")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40403 -- Schema not found\n"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    @PerformanceMetric(value="schemas.ids.get-schema")
    @RequirePermission(value=Permission.READ)
    public SchemaString getSchema(@ApiParam(value="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @DefaultValue(value="") @QueryParam(value="format") String format, @DefaultValue(value="false") @QueryParam(value="fetchMaxId") boolean fetchMaxId, @HeaderParam(value="Authorization") String auth, @HeaderParam(value="Cookie") String cookie) {
        return (SchemaString)ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> this.getSchema(id, format, fetchMaxId), (String)auth, (String)cookie);
    }

    private SchemaString getSchema(Integer id, String format, boolean fetchMaxId) {
        SchemaString schema = null;
        String errorMessage = "Error while retrieving schema with id " + id + " from the schema registry";
        try {
            schema = this.schemaRegistry.get(id, format, fetchMaxId);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (schema == null) {
            throw Errors.schemaNotFoundException(id);
        }
        return schema;
    }

    @GET
    @Path(value="/ids/{id}/subjects")
    @ApiOperation(value="Get all the subjects associated with the input ID.")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40403 -- Schema not found\n"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    @RequirePermission(value=Permission.READ)
    public Set<String> getSubjects(@ApiParam(value="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @HeaderParam(value="Authorization") String auth, @HeaderParam(value="Cookie") String cookie) {
        return (Set)ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> this.getSubjects(id), (String)auth, (String)cookie);
    }

    private Set<String> getSubjects(Integer id) {
        Set<String> subjects;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            subjects = this.schemaRegistry.listSubjectsForId(id);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (subjects == null) {
            throw Errors.schemaNotFoundException();
        }
        return subjects;
    }

    @GET
    @Path(value="/ids/{id}/versions")
    @ApiOperation(value="Get all the subject-version pairs associated with the input ID.")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40403 -- Schema not found\n"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    @RequirePermission(value=Permission.READ)
    public List<SubjectVersion> getVersions(@ApiParam(value="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @HeaderParam(value="Authorization") String auth, @HeaderParam(value="Cookie") String cookie) {
        return (List)ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> this.getVersions(id), (String)auth, (String)cookie);
    }

    private List<SubjectVersion> getVersions(Integer id) {
        List<SubjectVersion> versions;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            versions = this.schemaRegistry.listVersionsForId(id);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (versions == null) {
            throw Errors.schemaNotFoundException();
        }
        return versions;
    }

    @GET
    @Path(value="/types")
    @ApiOperation(value="Get the schema types supported by this registry.")
    @ApiResponses(value={@ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    @RequirePermission(value=Permission.READ)
    public Set<String> getSchemaTypes(@HeaderParam(value="Authorization") String auth, @HeaderParam(value="Cookie") String cookie) {
        return (Set)ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> this.getSchemaTypes(), (String)auth, (String)cookie);
    }

    private Set<String> getSchemaTypes() {
        return this.schemaRegistry.schemaTypes();
    }
}

