/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class JsonErrorHandler
extends ErrorHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getMethod();
        if (!(HttpMethod.GET.is(method) || HttpMethod.POST.is(method) || HttpMethod.PUT.is(method) || HttpMethod.HEAD.is(method))) {
            baseRequest.setHandled(true);
            return;
        }
        response.setContentType(MimeTypes.Type.APPLICATION_JSON.asString());
        String reason = response instanceof Response ? ((Response)response).getReason() : null;
        this.handleErrorPage(request, this.getAcceptableWriter(baseRequest, request, response), response.getStatus(), reason);
        baseRequest.setHandled(true);
        baseRequest.getResponse().closeOutput();
    }

    protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        String error = message == null ? HttpStatus.getMessage((int)code) : message;
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectNode root = factory.objectNode();
        root.put("error_code", code);
        root.put("message", error);
        writer.write(root.toString());
    }
}

