/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.zookeeper;

import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryInitializationException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.LeaderAwareSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LeaderElector;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.kafka.schemaregistry.utils.ZkUtils;
import java.io.IOException;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ZookeeperLeaderElector
implements LeaderElector {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperLeaderElector.class);
    @Deprecated
    private static final String LEADER_PATH = "/schema_registry_master";
    private final boolean isEligibleForLeaderElection;
    private final ZkClient zkClient;
    private final ZkUtils zkUtils;
    private final SchemaRegistryIdentity myIdentity;
    private final String myIdentityString;
    private final LeaderAwareSchemaRegistry schemaRegistry;

    public ZookeeperLeaderElector(SchemaRegistryConfig config, SchemaRegistryIdentity myIdentity, LeaderAwareSchemaRegistry schemaRegistry) throws SchemaRegistryStoreException {
        this.isEligibleForLeaderElection = myIdentity.getLeaderEligibility();
        this.zkUtils = config.zkUtils();
        this.zkClient = this.zkUtils.zkClient();
        this.myIdentity = myIdentity;
        try {
            this.myIdentityString = myIdentity.toJson();
        }
        catch (IOException e) {
            throw new SchemaRegistryStoreException(String.format("Error while serializing schema registry identity %s to json", myIdentity.toString()), e);
        }
        this.schemaRegistry = schemaRegistry;
        this.zkClient.subscribeStateChanges((IZkStateListener)new SessionExpirationListener());
        this.zkClient.subscribeDataChanges(LEADER_PATH, (IZkDataListener)new LeaderChangeListener());
    }

    @Override
    public void init() throws SchemaRegistryTimeoutException, SchemaRegistryStoreException, SchemaRegistryInitializationException, IdGenerationException {
        if (this.isEligibleForLeaderElection) {
            this.electLeader();
        } else {
            this.readCurrentLeader();
        }
    }

    @Override
    public void close() {
        this.zkClient.unsubscribeAll();
        this.zkUtils.close();
    }

    public void electLeader() throws SchemaRegistryStoreException, SchemaRegistryTimeoutException, SchemaRegistryInitializationException, IdGenerationException {
        SchemaRegistryIdentity leaderIdentity = null;
        try {
            this.zkUtils.createEphemeralPathExpectConflict(LEADER_PATH, this.myIdentityString);
            log.info("Successfully elected the new leader: " + this.myIdentityString);
            leaderIdentity = this.myIdentity;
            this.schemaRegistry.setLeader(leaderIdentity);
        }
        catch (ZkNodeExistsException znee) {
            this.readCurrentLeader();
        }
    }

    public void readCurrentLeader() throws SchemaRegistryTimeoutException, SchemaRegistryStoreException, SchemaRegistryInitializationException, IdGenerationException {
        SchemaRegistryIdentity leaderIdentity = null;
        try {
            String leaderIdentityString = this.zkUtils.readData(LEADER_PATH).getData();
            try {
                leaderIdentity = SchemaRegistryIdentity.fromJson(leaderIdentityString);
            }
            catch (IOException ioe) {
                log.error("Can't parse schema registry identity json string " + leaderIdentityString);
            }
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
        if (this.myIdentity.equals(leaderIdentity)) {
            log.error("The node's identity is same as elected leader. Check the ``listeners`` config or the ``host.name`` and the ``port`` config");
            throw new SchemaRegistryInitializationException("Invalid identity");
        }
        this.schemaRegistry.setLeader(leaderIdentity);
    }

    private class SessionExpirationListener
    implements IZkStateListener {
        public void handleStateChanged(Watcher.Event.KeeperState state) {
        }

        public void handleNewSession() throws Exception {
            if (ZookeeperLeaderElector.this.isEligibleForLeaderElection) {
                ZookeeperLeaderElector.this.electLeader();
            } else {
                ZookeeperLeaderElector.this.readCurrentLeader();
            }
        }

        public void handleSessionEstablishmentError(Throwable t) throws Exception {
            log.error("Failed to re-establish Zookeeper connection: ", t);
            throw new SchemaRegistryStoreException("Couldn't establish Zookeeper connection", t);
        }
    }

    private class LeaderChangeListener
    implements IZkDataListener {
        public void handleDataChange(String dataPath, Object data) {
            try {
                if (ZookeeperLeaderElector.this.isEligibleForLeaderElection) {
                    ZookeeperLeaderElector.this.electLeader();
                } else {
                    ZookeeperLeaderElector.this.readCurrentLeader();
                }
            }
            catch (SchemaRegistryException e) {
                log.error("Error while reading the schema registry leader", (Throwable)e);
            }
        }

        public void handleDataDeleted(String dataPath) throws Exception {
            if (ZookeeperLeaderElector.this.isEligibleForLeaderElection) {
                ZookeeperLeaderElector.this.electLeader();
            } else {
                ZookeeperLeaderElector.this.schemaRegistry.setLeader(null);
            }
        }
    }
}

