/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;

public class SecureTestUtils {
    public static Properties clientSslConfigsWithKeyStore(int numberOfCerts, File trustStoreFile, Password trustPassword, List<X509Certificate> clientCerts, List<KeyPair> keyPairs) throws GeneralSecurityException, IOException {
        HashMap<String, X509Certificate> certificateMap = new HashMap<String, X509Certificate>();
        File clientKSFile = File.createTempFile("CKeystore", ".jks");
        String keyStorePassword = new Password("Client-KS-Password").value();
        for (int i = 0; i < numberOfCerts; ++i) {
            KeyPair kp = TestSslUtils.generateKeyPair((String)"RSA");
            X509Certificate cert = TestSslUtils.generateCertificate((String)("CN=localhost, O=Client" + i), (KeyPair)kp, (int)30, (String)"SHA1withRSA");
            clientCerts.add(cert);
            keyPairs.add(kp);
            certificateMap.put("client-" + i, cert);
        }
        SecureTestUtils.createKeyStore(clientKSFile, keyStorePassword, clientCerts, keyPairs);
        TestSslUtils.createTrustStore((String)trustStoreFile.toString(), (Password)trustPassword, certificateMap);
        Properties sslConfigs = SecureTestUtils.getClientSslConfigs(trustStoreFile, trustPassword.value(), clientKSFile, keyStorePassword);
        return sslConfigs;
    }

    public static void createKeyStore(File keyStoreFile, String keyStorePassword, List<X509Certificate> clientCerts, List<KeyPair> keyPairs) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        for (int i = 0; i < clientCerts.size(); ++i) {
            keyStore.setKeyEntry("client-" + i, keyPairs.get(i).getPrivate(), keyStorePassword.toCharArray(), new Certificate[]{clientCerts.get(i)});
        }
        FileOutputStream out = new FileOutputStream(keyStoreFile);
        keyStore.store(out, keyStorePassword.toCharArray());
        out.close();
    }

    private static Properties getClientSslConfigs(File trustStoreFile, String trustPassword, File clientKSFile, String keyStorePassword) {
        System.setProperty("https.protocols", "TLSv1.2");
        Properties sslConfigs = new Properties();
        sslConfigs.put("ssl.protocol", "TLSv1.2");
        sslConfigs.put("ssl.keystore.location", clientKSFile.getPath());
        sslConfigs.put("ssl.keystore.type", "JKS");
        sslConfigs.put("ssl.keymanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        sslConfigs.put("ssl.keystore.password", keyStorePassword);
        sslConfigs.put("ssl.key.password", keyStorePassword);
        sslConfigs.put("ssl.truststore.location", trustStoreFile.getPath());
        sslConfigs.put("ssl.truststore.password", trustPassword);
        sslConfigs.put("ssl.truststore.type", "JKS");
        sslConfigs.put("ssl.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        sslConfigs.put("ssl.enabled.protocols", "TLSv1.2");
        sslConfigs.put("security.protocol", "SSL");
        return sslConfigs;
    }
}

