/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestIncompatibleSchemaException;
import org.junit.Assert;
import org.junit.Test;

public class RestApiTransitiveCompatibilityTest
extends ClusterTestHarness {
    String baseSchema = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
    String baseSchemaWithColumnWithDefault = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").canonicalString();
    String baseSchemaWithColumnNoDefault = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();

    public RestApiTransitiveCompatibilityTest() {
        super(1, true, CompatibilityLevel.BACKWARD_TRANSITIVE.name);
    }

    @Test
    public void testCompatibility() throws Exception {
        String subject = "testSubject";
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(this.baseSchema, subject));
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering a compatible schema should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(this.baseSchemaWithColumnWithDefault, subject));
        String incompatibleSchemaString = this.baseSchemaWithColumnNoDefault;
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assert.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
    }

    @Test
    public void validateTransitiveEffect() throws Exception {
        String subject = "testSubject";
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(this.baseSchemaWithColumnWithDefault, subject));
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering a compatible schema should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(this.baseSchemaWithColumnNoDefault, subject));
    }
}

