/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ns.MyRecord;
import org.junit.Assert;
import org.junit.Test;

public class RestApiTest
extends ClusterTestHarness {
    public RestApiTest() {
        super(1, true);
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = TestUtils.getRandomCanonicalAvroString(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = TestUtils.getRandomCanonicalAvroString(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        try {
            this.restApp.restClient.getAllVersions(subject1);
            Assert.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, subject1);
            Assert.assertEquals((String)"Re-registering an existing schema should return the existing version", (long)expectedId, (long)foundId);
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assert.assertEquals((String)"Getting all versions from subject1 should match all registered versions", allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1));
        Assert.assertEquals((String)"Getting all versions from subject2 should match all registered versions", allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2));
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testRegisterSameSchemaOnDifferentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        int id1 = this.restApp.restClient.registerSchema(schema, "subject1");
        int id2 = this.restApp.restClient.registerSchema(schema, "subject2");
        Assert.assertEquals((String)"Registering the same schema under different subjects should return the same id", (long)id1, (long)id2);
    }

    @Test
    public void testCompatibleSchemaLookupBySubject() throws Exception {
        String subject = "testSubject";
        int numRegisteredSchemas = 0;
        int numSchemas = 10;
        List<String> allSchemas = TestUtils.getRandomCanonicalAvroString(numSchemas);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        this.restApp.restClient.registerSchema(allSchemas.get(0), subject);
        ++numRegisteredSchemas;
        String schema1 = allSchemas.get(0);
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema1, subject, "latest");
        Assert.assertTrue((String)"First schema registered should be compatible", (boolean)isCompatible);
        for (int i = 0; i < numSchemas; ++i) {
            String schema = allSchemas.get(i);
            isCompatible = this.restApp.restClient.testCompatibility(schema, subject, "latest");
            TestUtils.checkNumberOfVersions(this.restApp.restClient, numRegisteredSchemas, subject);
        }
    }

    @Test
    public void testIncompatibleSchemaLookupBySubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"f\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        int versionOfRegisteredSchema = this.restApp.restClient.lookUpSubjectVersion(schema1, subject).getVersion();
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema2, subject, String.valueOf(versionOfRegisteredSchema));
        Assert.assertFalse((String)"Schema should be incompatible with specified version", (boolean)isCompatible);
    }

    @Test
    public void testSchemaRegistrationUnderDiffSubjects() throws Exception {
        String subject1 = "testSubject1";
        String subject2 = "testSubject2";
        String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schemaString1).canonicalString();
        String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"foo\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schemaString2).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject1);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject2);
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(schema1, subject1);
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(schema1, subject1).getVersion();
        Assert.assertEquals((String)"1st schema under subject1 should have version 1", (long)1L, (long)versionOfRegisteredSchema1Subject1);
        Assert.assertEquals((String)"1st schema registered globally should have id 1", (long)1L, (long)idOfRegisteredSchema1Subject1);
        int idOfRegisteredSchema2Subject1 = this.restApp.restClient.registerSchema(schema2, subject1);
        int versionOfRegisteredSchema2Subject1 = this.restApp.restClient.lookUpSubjectVersion(schema2, subject1).getVersion();
        Assert.assertEquals((String)"2nd schema under subject1 should have version 2", (long)2L, (long)versionOfRegisteredSchema2Subject1);
        Assert.assertEquals((String)"2nd schema registered globally should have id 2", (long)2L, (long)idOfRegisteredSchema2Subject1);
        int idOfRegisteredSchema2Subject2 = this.restApp.restClient.registerSchema(schema2, subject2);
        int versionOfRegisteredSchema2Subject2 = this.restApp.restClient.lookUpSubjectVersion(schema2, subject2).getVersion();
        Assert.assertEquals((String)"2nd schema under subject1 should still have version 1 as the first schema under subject2", (long)1L, (long)versionOfRegisteredSchema2Subject2);
        Assert.assertEquals((String)"Since schema is globally registered but not under subject2, id should not change", (long)2L, (long)idOfRegisteredSchema2Subject2);
    }

    @Test
    public void testConfigDefaults() throws Exception {
        Assert.assertEquals((String)"Default compatibility level should be none for this test instance", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null);
        Assert.assertEquals((String)"New compatibility level should be forward for this test instance", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testNonExistentSubjectConfigChange() throws Exception {
        String subject = "testSubject";
        try {
            this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, subject);
        }
        catch (RestClientException e) {
            Assert.fail((String)"Changing config for an invalid subject should succeed");
        }
        Assert.assertEquals((String)"New compatibility level for this subject should be forward", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel());
    }

    @Test
    public void testSubjectConfigChange() throws Exception {
        String subject = "testSubject";
        Assert.assertEquals((String)"Default compatibility level should be none for this test instance", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, subject);
        Assert.assertEquals((String)"Global compatibility level should remain none for this test instance", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        Assert.assertEquals((String)"New compatibility level for this subject should be forward", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel());
    }

    @Test
    public void testGetSchemaNonExistingId() throws Exception {
        try {
            this.restApp.restClient.getId(100);
            Assert.fail((String)"Schema lookup by missing id should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing id", (long)40403L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetSchemaWithFetchMaxId() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(3);
        int latestId = 0;
        for (String schema : schemas) {
            latestId = this.restApp.restClient.registerSchema(schema, "subject");
        }
        Assert.assertNull((Object)this.restApp.restClient.getId(1).getMaxId());
        Assert.assertEquals((Object)latestId, (Object)this.restApp.restClient.getId(1, true).getMaxId());
    }

    @Test
    public void testGetSchemaTypes() throws Exception {
        Assert.assertEquals(new HashSet<String>(Arrays.asList("AVRO", "JSON", "PROTOBUF")), new HashSet(this.restApp.restClient.getSchemaTypes()));
    }

    @Test
    public void testListVersionsNonExistingSubject() throws Exception {
        try {
            this.restApp.restClient.getAllVersions("Invalid");
            Assert.fail((String)"Getting all versions of missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetVersionNonExistentSubject() throws Exception {
        try {
            this.restApp.restClient.getVersion("non-existing-subject", 1);
            Assert.fail((String)"Getting version of missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Unregistered subject shouldn't be found in getVersion()", (long)40401L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testGetNonExistingVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.getVersion(subject, 200);
            Assert.fail((String)"Getting unregistered version should fail with 40402 (version not found)");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Unregistered version shouldn't be found", (long)40402L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testGetInvalidVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.getVersion(subject, 0);
            Assert.fail((String)"Getting invalid version should fail with 42202 (invalid version)");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Invalid version shouldn't be found", (long)42202L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testGetVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Version 1 schema should match", (Object)schemas.get(0), (Object)this.restApp.restClient.getVersion(subject, 1).getSchema());
        Assert.assertEquals((String)"Version 2 schema should match", (Object)schemas.get(1), (Object)this.restApp.restClient.getVersion(subject, 2).getSchema());
        Assert.assertEquals((String)"Latest schema should be the same as version 2", (Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema());
    }

    @Test
    public void testGetLatestVersionSchemaOnly() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Latest schema should be the same as version 2", (Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersionSchemaOnly(subject));
    }

    @Test
    public void testGetVersionSchemaOnly() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(1);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        Assert.assertEquals((String)"Retrieved schema should be the same as version 1", (Object)schemas.get(0), (Object)this.restApp.restClient.getVersionSchemaOnly(subject, 1));
    }

    @Test
    public void testSchemaReferences() throws Exception {
        List<String> schemas = TestUtils.getAvroSchemaWithReferences();
        String subject = "reference";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get(1));
        SchemaReference ref = new SchemaReference("otherns.Subrecord", "reference", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        int registeredId = this.restApp.restClient.registerSchema(request, "referrer");
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)2L, (long)registeredId);
        SchemaString schemaString = this.restApp.restClient.getId(2);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemas.get(1), (Object)schemaString.getSchemaString());
        Assert.assertEquals((String)"Schema references should be found", Collections.singletonList(ref), (Object)schemaString.getReferences());
        List refs = this.restApp.restClient.getReferencedBy("reference", 1);
        Assert.assertEquals((long)2L, (long)((Integer)refs.get(0)).intValue());
        MyRecord myrecord = new MyRecord();
        AvroSchema schema = new AvroSchema(AvroSchemaUtils.getSchema((Object)((Object)myrecord)));
        Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "AVRO", Collections.emptyList(), "referrer", false);
        Assert.assertEquals((String)"Registered schema should be found", (long)2L, (long)registeredSchema.getId().intValue());
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "reference", String.valueOf(1));
            Assert.fail((String)"Deleting reference should fail with 42206");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Reference found", (long)42206L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "referrer", "1"));
        refs = this.restApp.restClient.getReferencedBy("reference", 1);
        Assert.assertTrue((boolean)refs.isEmpty());
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "reference", "1"));
    }

    @Test(expected=RestClientException.class)
    public void testSchemaMissingReferences() throws Exception {
        List<String> schemas = TestUtils.getAvroSchemaWithReferences();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get(1));
        request.setReferences(Collections.emptyList());
        this.restApp.restClient.registerSchema(request, "referrer");
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, TestUtils.getBadSchema(), 1, subject1);
            Assert.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, TestUtils.getRandomCanonicalAvroString(1).get(0), Arrays.asList(new SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assert.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testLookUpSchemaUnderNonExistentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        try {
            this.restApp.restClient.lookUpSubjectVersion(schema, "non-existent-subject");
            Assert.fail((String)"Looking up schema under missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject not found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testLookUpNonExistentSchemaUnderSubject() throws Exception {
        String subject = "test";
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        try {
            this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject);
            Assert.fail((String)"Looking up missing schema under subject should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetSubjectsAssociatedWithSchemaId() throws Exception {
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject2);
        List associatedSubjects = this.restApp.restClient.getAllSubjectsById(1);
        Assert.assertEquals((long)associatedSubjects.size(), (long)2L);
        Assert.assertEquals(Arrays.asList(subject1, subject2), (Object)associatedSubjects);
    }

    @Test
    public void testGetSubjectsAssociatedWithNotFoundSchemaId() throws Exception {
        try {
            this.restApp.restClient.getAllSubjectsById(1);
            Assert.fail((String)"Getting all subjects associated with id 1 should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing schema", (long)40403L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetVersionsAssociatedWithSchemaId() throws Exception {
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject2);
        List associatedSubjects = this.restApp.restClient.getAllVersionsById(1);
        Assert.assertEquals((long)associatedSubjects.size(), (long)2L);
        Assert.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject1, Integer.valueOf(1))));
        Assert.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject2, Integer.valueOf(1))));
    }

    @Test
    public void testCompatibilityNonExistentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        try {
            this.restApp.restClient.testCompatibility(schema, "non-existent-subject", "latest");
            Assert.fail((String)"Testing compatibility for missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject not found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testCompatibilityNonExistentVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "100");
            Assert.fail((String)"Testing compatibility for missing version should fail with 40402 (version not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testCompatibilityInvalidVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "earliest");
            Assert.fail((String)"Testing compatibility for invalid version should fail with 42202 (version not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)42202L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetConfigNonExistentSubject() throws Exception {
        try {
            this.restApp.restClient.getConfig("non-existent-subject");
            Assert.fail((String)"Getting the configuration of a missing subject should fail with 40401 error code (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject not found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testCanonicalization() throws Exception {
        String schema = "{   \"type\":   \"string\"}";
        String subject = "test";
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)1L, (long)this.restApp.restClient.registerSchema(schema, subject));
        Assert.assertEquals((String)"Registering the same schema should get back the same id", (long)1L, (long)this.restApp.restClient.registerSchema(schema, subject));
        Assert.assertEquals((String)"Lookup the same schema should get back the same id", (long)1L, (long)this.restApp.restClient.lookUpSubjectVersion(schema, subject).getId().intValue());
    }

    @Test
    public void testDeleteSchemaVersionBasic() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2"));
        Assert.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getAllVersions(subject));
        try {
            this.restApp.restClient.getVersion(subject, 2);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get(1));
            this.restApp.restClient.lookUpSubjectVersion(new HashMap(), request, subject);
            Assert.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        try {
            List versions = this.restApp.restClient.getAllVersions(subject);
            Assert.fail((String)("Getting all versions from non-existing subject1 should fail with 40401 (subject not found). Got " + versions));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        for (int i = 0; i < 2; ++i) {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
            Assert.assertEquals(Collections.singletonList(3), (Object)this.restApp.restClient.getAllVersions(subject));
        }
    }

    @Test
    public void testDeleteSchemaVersionPermanent() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true);
            Assert.fail((String)String.format("Permanent deleting first time should throw schemaVersionNotSoftDeletedException", new Object[0]));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema version must be soft deleted first", (long)40407L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2"));
        Assert.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getAllVersions(subject));
        Assert.assertEquals(Arrays.asList(1, 2), (Object)this.restApp.restClient.getAllVersions(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true));
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
            Assert.fail((String)String.format("Soft deleting second time should throw schemaVersionSoftDeletedException", new Object[0]));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema version already soft deleted", (long)40406L, (long)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.getVersion(subject, 2);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        Schema schema = this.restApp.restClient.getVersion(subject, 2, true);
        Assert.assertEquals((String)"Lookup Version Match", (Object)2, (Object)schema.getVersion());
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get(1));
            this.restApp.restClient.lookUpSubjectVersion(new HashMap(), request, subject);
            Assert.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true));
        try {
            this.restApp.restClient.getVersion(subject, 2, true);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        try {
            List versions = this.restApp.restClient.getAllVersions(subject);
            Assert.fail((String)("Getting all versions from non-existing subject1 should fail with 40401 (subject not found). Got " + versions));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        for (int i = 0; i < 2; ++i) {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
            Assert.assertEquals(Collections.singletonList(2), (Object)this.restApp.restClient.getAllVersions(subject));
        }
    }

    @Test
    public void testDeleteSchemaVersionInvalidSubject() throws Exception {
        try {
            String subject = "test";
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
            Assert.fail((String)"Deleting a non existent subject version should fail with 40401 error code (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject not found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteLatestVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        Schema schema = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((String)"Latest Version Schema", (Object)schemas.get(0), (Object)schema.getSchema());
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assert.fail((String)"Getting latest versions from non-existing subject should fail with 40401 (subject not found).");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteInvalidVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(1);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject version", (long)40402L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteWithLookup() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"));
        try {
            this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
            Assert.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((String)"Lookup Version Match", (Object)1, (Object)schema.getVersion());
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((String)"Lookup Version Match", (Object)3, (Object)schema.getVersion());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
        Assert.assertEquals((String)"Lookup Version Match", (Object)3, (Object)schema.getVersion());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject);
        Assert.assertEquals((String)"Lookup Version Match", (Object)3, (Object)schema.getVersion());
    }

    @Test
    public void testIncompatibleSchemaLookupBySubjectAfterDelete() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String wrongSchema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String wrongSchema2 = AvroUtils.parseSchema((String)wrongSchema2String).canonicalString();
        String correctSchema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"int\",\"name\":\"g\" , \"default\":0}]}";
        String correctSchema2 = AvroUtils.parseSchema((String)correctSchema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        boolean isCompatible = this.restApp.restClient.testCompatibility(wrongSchema2, subject, "latest");
        Assert.assertTrue((String)"Schema should be compatible with specified version", (boolean)isCompatible);
        this.restApp.restClient.registerSchema(wrongSchema2, subject);
        isCompatible = this.restApp.restClient.testCompatibility(correctSchema2, subject, "latest");
        Assert.assertFalse((String)"Schema should be incompatible with specified version", (boolean)isCompatible);
        try {
            this.restApp.restClient.registerSchema(correctSchema2, subject);
            Assert.fail((String)"Schema should be Incompatible");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Incompatible Schema", (long)Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE, (long)rce.getErrorCode());
        }
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest");
        isCompatible = this.restApp.restClient.testCompatibility(correctSchema2, subject, "latest");
        Assert.assertTrue((String)"Schema should be compatible with specified version", (boolean)isCompatible);
        this.restApp.restClient.registerSchema(correctSchema2, subject);
        Assert.assertEquals((String)"Version is same", (Object)3, (Object)this.restApp.restClient.lookUpSubjectVersion(correctSchema2String, subject).getVersion());
    }

    @Test
    public void testSubjectCompatibilityAfterDeletingAllVersions() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, null);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
        Assert.assertEquals((String)"Compatibility Level Exists", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel());
        Assert.assertEquals((String)"Top Compatibility Level Exists", (Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
        try {
            this.restApp.restClient.getConfig(subject);
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Compatibility Level doesn't exist", (long)40401L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Top Compatibility Level Exists", (Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testListSubjects() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject1 = "test1";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject1);
        String subject2 = "test2";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject2);
        ArrayList<String> expectedResponse = new ArrayList<String>();
        expectedResponse.add(subject2);
        expectedResponse.add(subject1);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects());
        ArrayList<Integer> deletedResponse = new ArrayList<Integer>();
        deletedResponse.add(1);
        Assert.assertEquals((String)"Versions Deleted Match", deletedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject2));
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects());
        expectedResponse = new ArrayList();
        expectedResponse.add(subject2);
        expectedResponse.add(subject1);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects(true));
        Assert.assertEquals((String)"Versions Deleted Match", deletedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, true));
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testDeleteSubjectBasic() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject));
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assert.fail((String)String.format("Subject %s should not be found", subject));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject Not Found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteSubjectException() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject));
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((long)1L, (long)schema.getVersion().intValue());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject, true);
        Assert.assertEquals((long)2L, (long)schema.getVersion().intValue());
        try {
            this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
            Assert.fail((String)String.format("Subject %s should not be found", subject));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject exists in soft deleted format.", (long)40404L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteSubjectPermanent() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        try {
            this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true);
            Assert.fail((String)String.format("Delete permanent should not succeed", new Object[0]));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject '%s' was not deleted first before permanent delete", (long)40405L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject));
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((long)1L, (long)schema.getVersion().intValue());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject, true);
        Assert.assertEquals((long)2L, (long)schema.getVersion().intValue());
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true));
        for (Integer i : expectedResponse) {
            try {
                this.restApp.restClient.lookUpSubjectVersion(schemas.get(i - i), subject, false);
                Assert.fail((String)String.format("Subject %s should not be found", subject));
            }
            catch (RestClientException rce) {
                Assert.assertEquals((String)"Subject Not Found", (long)40401L, (long)rce.getErrorCode());
            }
            try {
                this.restApp.restClient.lookUpSubjectVersion(schemas.get(i - 1), subject, true);
                Assert.fail((String)String.format("Subject %s should not be found", subject));
            }
            catch (RestClientException rce) {
                Assert.assertEquals((String)"Subject Not Found", (long)40401L, (long)rce.getErrorCode());
            }
        }
    }

    @Test
    public void testDeleteSubjectAndRegister() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Versions match", Arrays.asList(3, 4), (Object)this.restApp.restClient.getAllVersions(subject));
        try {
            this.restApp.restClient.getVersion(subject, 1);
            Assert.fail((String)"Version 1 should not be found");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testSubjectCompatibilityAfterDeletingSubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, null);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
        try {
            this.restApp.restClient.getConfig(subject);
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Compatibility Level doesn't exist", (long)40401L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Top Compatibility Level Exists", (Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testGetClusterId() throws Exception {
        try {
            ServerClusterId serverClusterId = this.restApp.restClient.getClusterId();
            Assert.assertEquals((Object)"", (Object)serverClusterId.getId());
            Assert.assertEquals(Collections.emptyList(), serverClusterId.getScope().get("path"));
            Assert.assertNotNull(serverClusterId.getScope().get("clusters"));
        }
        catch (RestClientException rce) {
            Assert.fail((String)"The operation shouldn't have failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpResponseHeaders() throws Exception {
        String baseUrl = this.restApp.restClient.getBaseUrls().current();
        String requestUrl = this.buildRequestUrl(baseUrl, "/v1/metadata/id");
        HttpURLConnection connection = null;
        try {
            URL url = new URL(requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            Map<String, List<String>> httpResponseHeaders = connection.getHeaderFields();
            Assert.assertNotNull((Object)this.matchHeaderValue(httpResponseHeaders, "X-XSS-Protection", "1; mode=block"));
            Assert.assertNotNull((Object)this.matchHeaderValue(httpResponseHeaders, "Cache-Control", "no-cache, no-store, must-revalidate"));
            Assert.assertNull((Object)this.matchHeaderValue(httpResponseHeaders, "Strict-Transport-Security", "max-age=31536000"));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties schemaRegistryProps = new Properties();
        schemaRegistryProps.put("response.http.headers.config", "add X-XSS-Protection: 1; mode=block, \"add Cache-Control: no-cache, no-store, must-revalidate\"");
        return schemaRegistryProps;
    }

    private String matchHeaderValue(Map<String, List<String>> responseHeaders, String headerName, String expectedHeaderValue) {
        if (responseHeaders.isEmpty() || responseHeaders.get(headerName) == null) {
            return null;
        }
        return responseHeaders.get(headerName).stream().filter(value -> expectedHeaderValue.equals(value.trim())).findAny().orElse(null);
    }

    private String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }
}

