/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.RestApp;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.junit.Test;

public class NodeCountMetricTest
extends ClusterTestHarness {
    @Test
    public void testNodeCountMetric() throws Exception {
        int numFollowers = 2;
        int numLeaders = 2;
        HashSet<RestApp> followerApps = new HashSet<RestApp>();
        for (int i = 0; i < numFollowers; ++i) {
            RestApp follower = new RestApp(NodeCountMetricTest.choosePort(), null, this.bootstrapServers, "", CompatibilityLevel.NONE.name, false, null);
            followerApps.add(follower);
            follower.start();
        }
        HashSet<RestApp> leaderApps = new HashSet<RestApp>();
        for (int i = 0; i < numLeaders; ++i) {
            RestApp leader = new RestApp(NodeCountMetricTest.choosePort(), null, this.bootstrapServers, "", CompatibilityLevel.NONE.name, true, null);
            leaderApps.add(leader);
            leader.start();
            TestUtils.waitUntilLeaderElectionCompletes(leaderApps);
            this.checkNodeCountMetric(leaderApps, followerApps);
        }
        while (!leaderApps.isEmpty()) {
            RestApp reportedLeader = TestUtils.checkOneLeader(leaderApps);
            leaderApps.remove(reportedLeader);
            reportedLeader.stop();
            TestUtils.waitUntilLeaderElectionCompletes(leaderApps);
            this.checkNodeCountMetric(leaderApps, followerApps);
        }
        for (RestApp follower : followerApps) {
            follower.stop();
        }
    }

    private void checkNodeCountMetric(Collection<RestApp> ... apps) {
        long count = Arrays.stream(apps).map(x -> x.size()).reduce(0, Integer::sum).intValue();
        TestUtils.waitUntilTrue(() -> {
            for (Collection collection : apps) {
                for (RestApp app : collection) {
                    if (app.restApp.schemaRegistry().getMetricsContainer().getNodeCountMetric().get() == count) continue;
                    return false;
                }
            }
            return true;
        }, 3000L, "Metrics should have been updated by now");
    }
}

