/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.id.IncrementalIdGenerator;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.ClearSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.InMemoryCache;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.KafkaStoreMessageHandler;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.Store;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreTest
extends ClusterTestHarness {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreTest.class);
    private static final int ADMIN_TIMEOUT_SEC = 60;

    @Before
    public void setup() {
        log.debug("Zk conn url = " + this.zkConnect);
    }

    @After
    public void teardown() {
        log.debug("Shutting down");
    }

    @Test
    public void testInitialization() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers);
        kafkaStore.close();
    }

    @Test(expected=StoreInitializationException.class)
    public void testDoubleInitialization() throws Exception {
        try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers);){
            kafkaStore.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimplePut() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers);
        String key = "Kafka";
        String value = "Rocks";
        try {
            kafkaStore.put((Object)key, (Object)value);
            String retrievedValue = (String)kafkaStore.get((Object)key);
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleGetAfterFailure() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore);
        String key = "Kafka";
        String value = "Rocks";
        String retrievedValue = null;
        try {
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
        kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore);
        try {
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleDelete() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers);
        String key = "Kafka";
        String value = "Rocks";
        try {
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            String retrievedValue = null;
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
            try {
                kafkaStore.delete((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store delete(Kafka) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertNull((String)"Value should have been deleted", (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAfterRestart() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore);
        String key = "Kafka";
        String value = "Rocks";
        try {
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            String retrievedValue = null;
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
            try {
                kafkaStore.delete((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store delete(Kafka) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertNull((String)"Value should have been deleted", (Object)retrievedValue);
            kafkaStore.close();
            kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore);
            retrievedValue = value;
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertNull((String)"Value should have been deleted", (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    @Test
    public void testCustomGroupIdConfig() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        String groupId = "test-group-id";
        Properties props = new Properties();
        props.put("kafkastore.group.id", groupId);
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore, props);
        Assert.assertEquals((Object)kafkaStore.getKafkaStoreReaderThread().getConsumerProperty("group.id"), (Object)groupId);
    }

    @Test
    public void testDefaultGroupIdConfig() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        Properties props = new Properties();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore, props);
        Assert.assertTrue((boolean)kafkaStore.getKafkaStoreReaderThread().getConsumerProperty("group.id").startsWith("schema-registry-"));
    }

    @Test(expected=StoreInitializationException.class)
    public void testMandatoryCompactionPolicy() throws Exception {
        Properties kafkaProps = new Properties();
        HashMap<String, String> topicProps = new HashMap<String, String>();
        topicProps.put("cleanup.policy", "delete");
        NewTopic topic = new NewTopic("_schemas", 1, 1);
        topic.configs(topicProps);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        try (AdminClient admin = AdminClient.create((Properties)props);){
            admin.createTopics(Collections.singletonList(topic)).all().get(60L, TimeUnit.SECONDS);
        }
        InMemoryCache inMemoryStore = new InMemoryCache();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore, kafkaProps);
    }

    @Test(expected=StoreInitializationException.class)
    public void testTooManyPartitions() throws Exception {
        Properties kafkaProps = new Properties();
        HashMap<String, String> topicProps = new HashMap<String, String>();
        topicProps.put("cleanup.policy", "compact");
        NewTopic topic = new NewTopic("_schemas", 3, 1);
        topic.configs(topicProps);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        try (AdminClient admin = AdminClient.create((Properties)props);){
            admin.createTopics(Collections.singletonList(topic)).all().get(60L, TimeUnit.SECONDS);
        }
        InMemoryCache inMemoryStore = new InMemoryCache();
        StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore, kafkaProps);
    }

    @Test
    public void testTopicAdditionalConfigs() throws Exception {
        Map topicConfigs;
        Properties kafkaProps = new Properties();
        kafkaProps.put("kafkastore.topic.config.delete.retention.ms", "10000");
        kafkaProps.put("kafkastore.topic.config.segment.ms", "10000");
        InMemoryCache inMemoryStore = new InMemoryCache();
        StoreUtils.createAndInitKafkaStoreInstance(this.bootstrapServers, (Store<String, String>)inMemoryStore, kafkaProps);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "_schemas");
        try (AdminClient admin = AdminClient.create((Properties)props);){
            topicConfigs = (Map)admin.describeConfigs(Collections.singleton(configResource)).all().get(60L, TimeUnit.SECONDS);
        }
        Config config = (Config)topicConfigs.get(configResource);
        Assert.assertNotNull((Object)config.get("delete.retention.ms"));
        Assert.assertEquals((Object)"10000", (Object)config.get("delete.retention.ms").value());
        Assert.assertNotNull((Object)config.get("segment.ms"));
        Assert.assertEquals((Object)"10000", (Object)config.get("segment.ms").value());
    }

    @Test
    public void testGetAlwaysTrueHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsNotSet() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assert.assertTrue((boolean)schemaRegistry.getHostnameVerifier().verify("", null));
    }

    @Test
    public void testGetAlwaysTrueHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsNone() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        props.put("ssl.endpoint.identification.algorithm", "none");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assert.assertTrue((boolean)schemaRegistry.getHostnameVerifier().verify("", null));
    }

    @Test
    public void testGetAlwaysTrueHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsEmptyString() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        props.put("ssl.endpoint.identification.algorithm", "");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assert.assertTrue((boolean)schemaRegistry.getHostnameVerifier().verify("", null));
    }

    @Test
    public void testGetNullHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsHttps() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        props.put("ssl.endpoint.identification.algorithm", "https");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assert.assertNull((Object)schemaRegistry.getHostnameVerifier());
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdDifferentSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString2", false));
        int size = 0;
        Iterator iter = kafkaStore.getAllKeys();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        Assert.assertEquals((long)1L, (long)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdSameSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        int size = 0;
        Iterator iter = kafkaStore.getAllKeys();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        Assert.assertEquals((long)2L, (long)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdDifferentDeletedSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", true));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString2", false));
        int size = 0;
        Iterator iter = kafkaStore.getAllKeys();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        Assert.assertEquals((long)1L, (long)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdSameDeletedSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", true));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        int size = 0;
        Iterator iter = kafkaStore.getAllKeys();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        Assert.assertEquals((long)2L, (long)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerDeleteSubjectKeyNullValue() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStoreMessageHandler storeMessageHandler = new KafkaStoreMessageHandler(schemaRegistry, (LookupCache)new InMemoryCache(), (IdGenerator)new IncrementalIdGenerator());
        storeMessageHandler.handleUpdate((SchemaRegistryKey)new DeleteSubjectKey("test"), null, null, null, 0L, 0L);
    }

    @Test
    public void testKafkaStoreMessageHandlerClearSubjectKeyNullValue() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.bootstrapServers);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStoreMessageHandler storeMessageHandler = new KafkaStoreMessageHandler(schemaRegistry, (LookupCache)new InMemoryCache(), (IdGenerator)new IncrementalIdGenerator());
        storeMessageHandler.handleUpdate((SchemaRegistryKey)new ClearSubjectKey("test"), null, null, null, 0L, 0L);
    }
}

