/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class KafkaSchemaRegistryTest {
    @Test
    public void testGetPortForIdentityPrecedence() throws SchemaRegistryException {
        LinkedList<String> listeners = new LinkedList<String>();
        listeners.add("http://localhost:456");
        KafkaSchemaRegistry.SchemeAndPort schemeAndPort = KafkaSchemaRegistry.getSchemeAndPortForIdentity((int)123, listeners, (String)"http");
        Assert.assertEquals((String)"Expected listeners to take precedence over port.", (long)456L, (long)schemeAndPort.port);
        Assert.assertEquals((String)"Expected Scheme match", (Object)"http", (Object)schemeAndPort.scheme);
    }

    @Test
    public void testGetPortForIdentityNoListeners() throws SchemaRegistryException {
        LinkedList listeners = new LinkedList();
        KafkaSchemaRegistry.SchemeAndPort schemeAndPort = KafkaSchemaRegistry.getSchemeAndPortForIdentity((int)123, listeners, (String)"http");
        Assert.assertEquals((String)"Expected port to take the configured port value", (long)123L, (long)schemeAndPort.port);
        Assert.assertEquals((String)"Expected Scheme match", (Object)"http", (Object)schemeAndPort.scheme);
    }

    @Test
    public void testGetPortForIdentityMultipleListenersWithHttps() throws SchemaRegistryException {
        LinkedList<String> listeners = new LinkedList<String>();
        listeners.add("http://localhost:123");
        listeners.add("https://localhost:456");
        KafkaSchemaRegistry.SchemeAndPort schemeAndPort = KafkaSchemaRegistry.getSchemeAndPortForIdentity((int)-1, listeners, (String)"https");
        Assert.assertEquals((String)"Expected HTTPS listener's port to be returned", (long)456L, (long)schemeAndPort.port);
        Assert.assertEquals((String)"Expected Scheme match", (Object)"https", (Object)schemeAndPort.scheme);
    }

    @Test
    public void testGetPortForIdentityMultipleListeners() throws SchemaRegistryException {
        LinkedList<String> listeners = new LinkedList<String>();
        listeners.add("http://localhost:123");
        listeners.add("http://localhost:456");
        KafkaSchemaRegistry.SchemeAndPort schemeAndPort = KafkaSchemaRegistry.getSchemeAndPortForIdentity((int)-1, listeners, (String)"http");
        Assert.assertEquals((String)"Expected first listener's port to be returned", (long)123L, (long)schemeAndPort.port);
        Assert.assertEquals((String)"Expected Scheme match", (Object)"http", (Object)schemeAndPort.scheme);
    }
}

