/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import io.confluent.kafka.schemaregistry.RestApp;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import org.junit.Assert;

public class TestUtils {
    private static final String IoTmpDir = System.getProperty("java.io.tmpdir");
    private static final Random random = new Random();

    public static File tempDir(String namePrefix) {
        final File f = new File(IoTmpDir, namePrefix + "-" + random.nextInt(1000000));
        f.mkdirs();
        f.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TestUtils.rm(f);
            }
        });
        return f;
    }

    public static void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    TestUtils.rm(f);
                }
            }
        } else {
            file.delete();
        }
    }

    public static void waitUntilTrue(Callable<Boolean> callable, long timeoutMs, String errorMsg) {
        try {
            long startTime = System.currentTimeMillis();
            Boolean state = false;
            do {
                state = callable.call();
                if (System.currentTimeMillis() > startTime + timeoutMs) {
                    Assert.fail((String)errorMsg);
                }
                Thread.sleep(50L);
            } while (!state.booleanValue());
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception: " + e));
        }
    }

    public static void checkNumberOfVersions(RestService restService, int expected, String subject) throws IOException, RestClientException {
        List versions = restService.getAllVersions(subject);
        Assert.assertEquals((String)("Expected " + expected + " registered versions under subject " + subject + ", but found " + versions.size()), (long)expected, (long)versions.size());
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, subject);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemaString, (Object)restService.getId(expectedId).getSchemaString());
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<SchemaReference> references, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, "AVRO", references, subject);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemaString, (Object)restService.getId(expectedId).getSchemaString());
    }

    public static List<String> getRandomCanonicalAvroString(int num) {
        ArrayList<String> avroStrings = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + random.nextInt(Integer.MAX_VALUE) + "\"}]}";
            avroStrings.add(AvroUtils.parseSchema((String)schemaString).canonicalString());
        }
        return avroStrings;
    }

    public static List<String> getAvroSchemaWithReferences() {
        ArrayList<String> schemas = new ArrayList<String>();
        String reference = "{\"type\":\"record\",\"name\":\"Subrecord\",\"namespace\":\"otherns\",\"fields\":[{\"name\":\"field2\",\"type\":\"string\"}]}";
        schemas.add(reference);
        String schemaString = "{\"type\":\"record\",\"name\":\"MyRecord\",\"namespace\":\"ns\",\"fields\":[{\"name\":\"field1\",\"type\":\"otherns.Subrecord\"}]}";
        schemas.add(schemaString);
        return schemas;
    }

    public static String getBadSchema() {
        String schemaString = "{\"type\":\"bad-record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + random.nextInt(Integer.MAX_VALUE) + "\"}]}";
        return schemaString;
    }

    public static RestApp findLeader(Collection<RestApp> cluster) {
        for (RestApp restApp : cluster) {
            if (!restApp.isLeader()) continue;
            return restApp;
        }
        return null;
    }

    public static Set<SchemaRegistryIdentity> getLeaderIdentities(Collection<RestApp> cluster) {
        HashSet<SchemaRegistryIdentity> leaderIdentities = new HashSet<SchemaRegistryIdentity>();
        for (RestApp app : cluster) {
            if (app == null || app.leaderIdentity() == null) continue;
            leaderIdentities.add(app.leaderIdentity());
        }
        return leaderIdentities;
    }

    public static void waitUntilLeaderElectionCompletes(final Collection<RestApp> cluster) {
        if (cluster == null || cluster.size() == 0) {
            return;
        }
        Callable<Boolean> newLeaderElected = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean hasLeader = TestUtils.findLeader(cluster) != null;
                boolean oneReportedLeader = TestUtils.getLeaderIdentities(cluster).size() == 1;
                return hasLeader && oneReportedLeader;
            }
        };
        TestUtils.waitUntilTrue(newLeaderElected, 15000L, "A node should have been elected leader by now.");
    }

    public static RestApp checkOneLeader(Collection<RestApp> cluster) {
        int leaderCount = 0;
        RestApp leader = null;
        for (RestApp restApp : cluster) {
            if (!restApp.isLeader()) continue;
            ++leaderCount;
            leader = restApp;
        }
        Assert.assertEquals((String)("Expected one leader but found " + leaderCount), (long)1L, (long)leaderCount);
        return leader;
    }
}

