/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.metrics.MetricsContainer;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Test;

public class MetricsTest
extends ClusterTestHarness {
    private MetricsContainer container;

    public MetricsTest() {
        super(1, true);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.container = this.restApp.restApp.schemaRegistry().getMetricsContainer();
    }

    @Test
    public void testLeaderFollowerMetric() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName leaderFollowerMetricName = new ObjectName("kafka.schema.registry:type=master-slave-role");
        Assert.assertEquals((Object)1.0, (Object)mBeanServer.getAttribute(leaderFollowerMetricName, "master-slave-role"));
    }

    @Test
    public void testSchemaCreatedCount() throws Exception {
        int i;
        RestService service = this.restApp.restClient;
        String subject = "testTopic1";
        int schemaCount = 3;
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(schemaCount);
        int schemaIdCounter = 1;
        for (i = 0; i < schemaCount; ++i) {
            String schema = schemas.get(i);
            TestUtils.registerAndVerifySchema(service, schema, schemaIdCounter++, subject);
        }
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasCreated().get());
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasCreated("AVRO").get());
        for (i = 0; i < schemaCount; ++i) {
            String schemaString = schemas.get(i);
            service.registerSchema(schemaString, subject);
        }
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasCreated().get());
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasCreated("AVRO").get());
        Integer i2 = 1;
        while (i2 < schemaIdCounter) {
            Assert.assertEquals((Object)i2, (Object)service.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, i2.toString()));
            Integer n = i2;
            Integer n2 = i2 = Integer.valueOf(i2 + 1);
        }
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasCreated().get());
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasCreated("AVRO").get());
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasDeleted().get());
        Assert.assertEquals((long)schemaCount, (long)this.container.getSchemasDeleted("AVRO").get());
    }

    @Test
    public void testApiCallMetrics() throws Exception {
        String subject = "testTopic1";
        int schemaCount = 3;
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(schemaCount);
        int schemaIdCounter = 1;
        for (int i = 0; i < schemaCount; ++i) {
            String schema = schemas.get(i);
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter++, subject);
        }
        Assert.assertEquals((long)(schemaCount * 2), (long)this.container.getApiCallsSuccess().get());
        Assert.assertEquals((long)0L, (long)this.container.getApiCallsFailure().get());
        try {
            this.restApp.restClient.getId(100);
            Assert.fail((String)"Schema lookup with missing ID expected to fail");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((long)1L, (long)this.container.getApiCallsFailure().get());
        }
    }
}

