/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.util;

import com.mapr.fs.MapRFileAce;
import com.mapr.fs.MapRFileSystem;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStreamsException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import java.io.IOException;
import java.util.Optional;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprStreams;
import org.apache.kafka.mapr.tools.KafkaMaprTools;
import org.apache.kafka.mapr.tools.KafkaMaprfs;
import org.apache.kafka.mapr.tools.MaprfsPermissions;

public class MaprFSUtils {
    public static void createKafkaStoreInternalStreamIfNotExist(SchemaRegistryConfig config) {
        KafkaMaprfs maprfs = KafkaMaprTools.tools().maprfs();
        if (!maprfs.exists("/apps/schema-registry/")) {
            maprfs.mkdirs("/apps/schema-registry/");
            maprfs.setPermissions("/apps/schema-registry/", MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "p").put(MapRFileAce.AccessType.LOOKUPDIR, "p").put(MapRFileAce.AccessType.ADDCHILD, "<startup.user>").put(MapRFileAce.AccessType.DELETECHILD, "<startup.user>").put(MapRFileAce.AccessType.WRITEFILE, "<startup.user>"));
        }
        maprfs.requireExisting("/apps/schema-registry/");
        String internalFolder = config.getKafkaStoreStreamFolder();
        if (!maprfs.exists(internalFolder)) {
            maprfs.mkdirs(internalFolder);
            maprfs.setPermissions(internalFolder, MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "p").put(MapRFileAce.AccessType.LOOKUPDIR, "p").put(MapRFileAce.AccessType.ADDCHILD, "<startup.user>").put(MapRFileAce.AccessType.DELETECHILD, "<startup.user>").put(MapRFileAce.AccessType.WRITEFILE, "<startup.user>"));
        }
        try (KafkaMaprStreams maprStreams = KafkaMaprTools.tools().streams();){
            maprStreams.createStreamForAllUsers(config.getKafkaStoreStream());
            maprStreams.ensureStreamLogCompactionIsEnabled(config.getKafkaStoreStream());
        }
    }

    public static String getZKQuorum() {
        try {
            MapRFileSystem mfs = KafkaMaprTools.tools().getMapRFileSystem();
            return Optional.ofNullable(mfs.getZkConnectString()).orElseThrow(() -> new IOException("Cannot receive Zookeeper URL from MapR-FS"));
        }
        catch (RuntimeException e) {
            throw new SchemaRegistryStreamsException("Zookeeper cannot be reached", e);
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }
}

