/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryCache<K, V>
implements LookupCache<K, V> {
    private final ConcurrentSkipListMap<K, V> store = new ConcurrentSkipListMap();
    private final Map<Integer, SchemaKey> guidToSchemaKey = new ConcurrentHashMap<Integer, SchemaKey>();
    private final Map<MD5, SchemaIdAndSubjects> schemaHashToGuid = new ConcurrentHashMap<MD5, SchemaIdAndSubjects>();
    private final Map<Integer, List<SchemaKey>> guidToDeletedSchemaKeys = new ConcurrentHashMap<Integer, List<SchemaKey>>();

    @Override
    public void init() throws StoreInitializationException {
    }

    @Override
    public V get(K key) {
        return this.store.get(key);
    }

    @Override
    public void put(K key, V value) throws StoreException {
        this.store.put(key, value);
    }

    @Override
    public Iterator<V> getAll(K key1, K key2) {
        SortedMap<K, V> subMap = key1 == null && key2 == null ? this.store : this.store.subMap((Object)key1, (Object)key2);
        return subMap.values().iterator();
    }

    @Override
    public void putAll(Map<K, V> entries) {
        this.store.putAll(entries);
    }

    @Override
    public void delete(K key) throws StoreException {
        this.store.remove(key);
    }

    @Override
    public Iterator<K> getAllKeys() throws StoreException {
        return this.store.keySet().iterator();
    }

    @Override
    public void close() {
        this.store.clear();
    }

    @Override
    public SchemaIdAndSubjects schemaIdAndSubjects(Schema schema) {
        MD5 md5 = MD5.ofString(schema.getSchema());
        return this.schemaHashToGuid.get(md5);
    }

    @Override
    public boolean containsSchema(Schema schema) {
        MD5 md5 = MD5.ofString(schema.getSchema());
        return this.schemaHashToGuid.containsKey(md5);
    }

    @Override
    public SchemaKey schemaKeyById(Integer id) {
        return this.guidToSchemaKey.get(id);
    }

    @Override
    public void schemaDeleted(SchemaKey schemaKey, SchemaValue schemaValue) {
        this.guidToSchemaKey.put(schemaValue.getId(), schemaKey);
        this.guidToDeletedSchemaKeys.computeIfAbsent(schemaValue.getId(), k -> new ArrayList()).add(schemaKey);
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue) {
        this.guidToSchemaKey.put(schemaValue.getId(), schemaKey);
        MD5 md5 = MD5.ofString(schemaValue.getSchema());
        SchemaIdAndSubjects schemaIdAndSubjects = this.schemaHashToGuid.get(md5);
        if (schemaIdAndSubjects == null) {
            schemaIdAndSubjects = new SchemaIdAndSubjects(schemaValue.getId());
        }
        schemaIdAndSubjects.addSubjectAndVersion(schemaKey.getSubject(), schemaKey.getVersion());
        this.schemaHashToGuid.put(md5, schemaIdAndSubjects);
    }

    @Override
    public List<SchemaKey> deletedSchemaKeys(SchemaValue schemaValue) {
        return this.guidToDeletedSchemaKeys.getOrDefault(schemaValue.getId(), Collections.emptyList());
    }
}

