/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.filter;

import io.confluent.kafka.schemaregistry.filter.Permission;
import io.confluent.kafka.schemaregistry.rest.exceptions.AuthorizationException;
import io.confluent.kafka.schemaregistry.util.ByteConsumerPool;
import io.confluent.kafka.schemaregistry.util.ByteProducerPool;
import io.confluent.rest.auth.MaprAuthenticationUtils;
import io.confluent.rest.impersonation.ImpersonationUtils;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;

public class AuthorizationFilter
implements ContainerRequestFilter {
    private ByteConsumerPool consumerPool;
    private ByteProducerPool producerPool;
    private final String internalTopic;
    @Context
    protected ResourceInfo resourceInfo;

    public AuthorizationFilter(ByteConsumerPool consumerPool, ByteProducerPool producerPool, String internalTopic) {
        this.internalTopic = internalTopic;
        this.consumerPool = consumerPool;
        this.producerPool = producerPool;
    }

    public void filter(ContainerRequestContext requestContext) {
        try {
            String userName = MaprAuthenticationUtils.getUserNameFromRequestContext((ContainerRequestContext)requestContext);
            ImpersonationUtils.executor().runAs(userName, () -> {
                this.checkPermissions();
                return null;
            });
        }
        catch (Exception e) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build());
        }
    }

    public void initialize() {
        try {
            this.checkWritingPermissions();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private void checkPermissions() {
        try {
            Class resourceClass = this.resourceInfo.getResourceClass();
            Method resourceMethod = this.resourceInfo.getResourceMethod();
            Permission permission = Permission.at(resourceClass, resourceMethod);
            switch (permission) {
                case READ: {
                    this.checkReadingPermissions();
                    break;
                }
                case MODIFY: {
                    this.checkWritingPermissions();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("Access denied. This operation is not permitted for current user\n");
        }
    }

    private void checkWritingPermissions() throws ExecutionException, InterruptedException {
        ProducerRecord record = new ProducerRecord(this.internalTopic, (Object)new byte[0]);
        this.producerPool.send((ProducerRecord<byte[], byte[]>)record).get();
    }

    private void checkReadingPermissions() {
        ConsumerRecords<byte[], byte[]> records = this.consumerPool.poll(this.internalTopic);
        if (records.count() < 1) {
            throw new AuthorizationException("Access denied. This operation is not permitted for current user\n");
        }
    }
}

