/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class RequestHeaderBuilderTest {
    @Test
    public void testHeaderProperties() {
        HttpHeaders httpHeaders = (HttpHeaders)EasyMock.createMock(HttpHeaders.class);
        EasyMock.expect((Object)httpHeaders.getHeaderString("Content-Type")).andReturn((Object)"application/json");
        EasyMock.expect((Object)httpHeaders.getHeaderString("Accept")).andReturn((Object)"application/json");
        EasyMock.expect((Object)httpHeaders.getHeaderString("Authorization")).andReturn((Object)"test");
        EasyMock.replay((Object[])new Object[]{httpHeaders});
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"application/json", requestProps.get("Content-Type"));
        Assert.assertEquals((Object)"application/json", requestProps.get("Accept"));
        Assert.assertEquals((Object)"test", requestProps.get("Authorization"));
    }

    @Test
    public void testEmptyProperty() {
        HttpHeaders httpHeaders = (HttpHeaders)EasyMock.createMock(HttpHeaders.class);
        EasyMock.expect((Object)httpHeaders.getHeaderString("Content-Type")).andReturn((Object)"application/json");
        EasyMock.expect((Object)httpHeaders.getHeaderString("Accept")).andReturn((Object)"application/json");
        EasyMock.expect((Object)httpHeaders.getHeaderString("Authorization")).andReturn((Object)"");
        EasyMock.replay((Object[])new Object[]{httpHeaders});
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"application/json", requestProps.get("Content-Type"));
        Assert.assertEquals((Object)"application/json", requestProps.get("Accept"));
        Assert.assertNull(requestProps.get("Authorization"));
    }

    @Test
    public void testMissingProperty() {
        HttpHeaders httpHeaders = (HttpHeaders)EasyMock.createMock(HttpHeaders.class);
        EasyMock.expect((Object)httpHeaders.getHeaderString("Content-Type")).andReturn((Object)"application/json");
        EasyMock.expect((Object)httpHeaders.getHeaderString("Accept")).andReturn((Object)"application/json");
        EasyMock.expect((Object)httpHeaders.getHeaderString("Authorization")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{httpHeaders});
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"application/json", requestProps.get("Content-Type"));
        Assert.assertEquals((Object)"application/json", requestProps.get("Accept"));
        Assert.assertNull(requestProps.get("Authorization"));
    }
}

