/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityChecker;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;

public class AvroCompatibilityTest {
    private final String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}";
    private final Schema schema1;
    private final String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}";
    private final Schema schema2;
    private final String schemaString3 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}";
    private final Schema schema3;
    private final String schemaString4 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1_new\", \"aliases\": [\"f1\"]}]}";
    private final Schema schema4;
    private final String schemaString6 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
    private final Schema schema6;
    private final String schemaString7 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\", \"int\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
    private final Schema schema7;
    private final String schemaString8 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}";
    private final Schema schema8;

    public AvroCompatibilityTest() {
        this.schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").schemaObj;
        this.schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}";
        this.schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").schemaObj;
        this.schemaString3 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}";
        this.schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").schemaObj;
        this.schemaString4 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1_new\", \"aliases\": [\"f1\"]}]}";
        this.schema4 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1_new\", \"aliases\": [\"f1\"]}]}").schemaObj;
        this.schemaString6 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
        this.schema6 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}").schemaObj;
        this.schemaString7 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\", \"int\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
        this.schema7 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\", \"int\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}").schemaObj;
        this.schemaString8 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}";
        this.schema8 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}").schemaObj;
    }

    @Test
    public void testBasicBackwardsCompatibility() {
        AvroCompatibilityChecker checker = AvroCompatibilityChecker.BACKWARD_CHECKER;
        Assert.assertTrue((String)"adding a field with default is a backward compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema1)));
        Assert.assertFalse((String)"adding a field w/o default is not a backward compatible change", (boolean)checker.isCompatible(this.schema3, Collections.singletonList(this.schema1)));
        Assert.assertFalse((String)"changing field name is not a backward compatible change", (boolean)checker.isCompatible(this.schema4, Collections.singletonList(this.schema1)));
        Assert.assertTrue((String)"evolving a field type to a union is a backward compatible change", (boolean)checker.isCompatible(this.schema6, Collections.singletonList(this.schema1)));
        Assert.assertFalse((String)"removing a type from a union is not a backward compatible change", (boolean)checker.isCompatible(this.schema1, Collections.singletonList(this.schema6)));
        Assert.assertTrue((String)"adding a new type in union is a backward compatible change", (boolean)checker.isCompatible(this.schema7, Collections.singletonList(this.schema6)));
        Assert.assertFalse((String)"removing a type from a union is not a backward compatible change", (boolean)checker.isCompatible(this.schema6, Collections.singletonList(this.schema7)));
        Assert.assertTrue((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible(this.schema3, Arrays.asList(this.schema1, this.schema2)));
    }

    @Test
    public void testBasicBackwardsTransitiveCompatibility() {
        AvroCompatibilityChecker checker = AvroCompatibilityChecker.BACKWARD_TRANSITIVE_CHECKER;
        Assert.assertTrue((String)"iteratively adding fields with defaults is a compatible change", (boolean)checker.isCompatible(this.schema8, Arrays.asList(this.schema1, this.schema2)));
        Assert.assertTrue((String)"adding a field with default is a backward compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema1)));
        Assert.assertTrue((String)"removing a default is a compatible change, but not transitively", (boolean)checker.isCompatible(this.schema3, Arrays.asList(this.schema2)));
        Assert.assertFalse((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible(this.schema3, Arrays.asList(this.schema2, this.schema1)));
    }

    @Test
    public void testBasicForwardsCompatibility() {
        AvroCompatibilityChecker checker = AvroCompatibilityChecker.FORWARD_CHECKER;
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema1)));
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible(this.schema3, Collections.singletonList(this.schema1)));
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible(this.schema3, Collections.singletonList(this.schema2)));
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema3)));
        Assert.assertTrue((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema3, this.schema2)));
    }

    @Test
    public void testBasicForwardsTransitiveCompatibility() {
        AvroCompatibilityChecker checker = AvroCompatibilityChecker.FORWARD_TRANSITIVE_CHECKER;
        Assert.assertTrue((String)"iteratively removing fields with defaults is a compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema8, this.schema2)));
        Assert.assertTrue((String)"adding default to a field is a compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema3)));
        Assert.assertTrue((String)"removing a field with a default is a compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema2)));
        Assert.assertFalse((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema2, this.schema3)));
    }

    @Test
    public void testBasicFullCompatibility() {
        AvroCompatibilityChecker checker = AvroCompatibilityChecker.FULL_CHECKER;
        Assert.assertTrue((String)"adding a field with default is a backward and a forward compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema1)));
        Assert.assertTrue((String)"transitively adding a field without a default is not a compatible change", (boolean)checker.isCompatible(this.schema3, Arrays.asList(this.schema1, this.schema2)));
        Assert.assertTrue((String)"transitively removing a field without a default is not a compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema3, this.schema2)));
    }

    @Test
    public void testBasicFullTransitiveCompatibility() {
        AvroCompatibilityChecker checker = AvroCompatibilityChecker.FULL_TRANSITIVE_CHECKER;
        Assert.assertTrue((String)"iteratively adding fields with defaults is a compatible change", (boolean)checker.isCompatible(this.schema8, Arrays.asList(this.schema1, this.schema2)));
        Assert.assertTrue((String)"iteratively removing fields with defaults is a compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema8, this.schema2)));
        Assert.assertTrue((String)"adding default to a field is a compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema3)));
        Assert.assertTrue((String)"removing a field with a default is a compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema2)));
        Assert.assertTrue((String)"adding a field with default is a compatible change", (boolean)checker.isCompatible(this.schema2, Collections.singletonList(this.schema1)));
        Assert.assertTrue((String)"removing a default from a field compatible change", (boolean)checker.isCompatible(this.schema3, Arrays.asList(this.schema2)));
        Assert.assertFalse((String)"transitively adding a field without a default is not a compatible change", (boolean)checker.isCompatible(this.schema3, Arrays.asList(this.schema2, this.schema1)));
        Assert.assertFalse((String)"transitively removing a field without a default is not a compatible change", (boolean)checker.isCompatible(this.schema1, Arrays.asList(this.schema2, this.schema3)));
    }
}

