/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import java.util.HashMap;
import java.util.Map;

public class SchemaIdAndSubjects {
    private int id;
    private Map<String, Integer> subjectsAndVersions = new HashMap<String, Integer>();

    public SchemaIdAndSubjects(int id) {
        this.id = id;
    }

    public void addSubjectAndVersion(String subject, int version) {
        this.subjectsAndVersions.put(subject, version);
    }

    public boolean hasSubject(String subject) {
        return this.subjectsAndVersions.keySet().contains(subject);
    }

    public int getVersion(String subject) {
        return this.subjectsAndVersions.get(subject);
    }

    public int getSchemaId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaIdAndSubjects that = (SchemaIdAndSubjects)o;
        if (this.id != that.id) {
            return false;
        }
        return this.subjectsAndVersions.equals(that.subjectsAndVersions);
    }

    public int hashCode() {
        int result = 31 * this.id;
        result = 31 * result + this.subjectsAndVersions.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id=" + this.id + ",");
        sb.append("subjectsAndVersions=" + this.subjectsAndVersions.toString() + "}");
        return sb.toString();
    }
}

