/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.InMemoryCache;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.Store;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import java.util.Iterator;
import java.util.Properties;
import kafka.log.LogConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreTest
extends ClusterTestHarness {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreTest.class);

    @Before
    public void setup() {
        log.debug("Zk conn url = " + this.zkConnect);
    }

    @After
    public void teardown() {
        log.debug("Shutting down");
    }

    @Test
    public void testInitialization() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect);
        kafkaStore.close();
    }

    @Test(expected=StoreInitializationException.class)
    public void testDoubleInitialization() throws Exception {
        try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect);){
            kafkaStore.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimplePut() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect);
        String key = "Kafka";
        String value = "Rocks";
        try {
            kafkaStore.put((Object)key, (Object)value);
            String retrievedValue = (String)kafkaStore.get((Object)key);
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleGetAfterFailure() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore);
        String key = "Kafka";
        String value = "Rocks";
        String retrievedValue = null;
        try {
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
        kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore);
        try {
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleDelete() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect);
        String key = "Kafka";
        String value = "Rocks";
        try {
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            String retrievedValue = null;
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
            try {
                kafkaStore.delete((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store delete(Kafka) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertNull((String)"Value should have been deleted", (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAfterRestart() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore);
        String key = "Kafka";
        String value = "Rocks";
        try {
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            String retrievedValue = null;
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
            try {
                kafkaStore.delete((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store delete(Kafka) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertNull((String)"Value should have been deleted", (Object)retrievedValue);
            kafkaStore.close();
            kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore);
            retrievedValue = value;
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assert.assertNull((String)"Value should have been deleted", (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }

    @Test
    public void testCustomGroupIdConfig() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        String groupId = "test-group-id";
        Properties props = new Properties();
        props.put("kafkastore.group.id", groupId);
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore, props);
        Assert.assertEquals((Object)kafkaStore.getKafkaStoreReaderThread().getConsumerProperty("group.id"), (Object)groupId);
    }

    @Test
    public void testDefaultGroupIdConfig() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache();
        Properties props = new Properties();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore, props);
        Assert.assertTrue((boolean)kafkaStore.getKafkaStoreReaderThread().getConsumerProperty("group.id").startsWith("schema-registry-"));
    }

    @Test(expected=StoreInitializationException.class)
    public void testMandatoryCompationPolicy() throws Exception {
        Properties kafkaProps = new Properties();
        Properties topicProps = new Properties();
        topicProps.put(LogConfig.CleanupPolicyProp(), "delete");
        InMemoryCache inMemoryStore = new InMemoryCache();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore, kafkaProps);
    }

    @Test(expected=StoreInitializationException.class)
    public void testTooManyPartitions() throws Exception {
        Properties kafkaProps = new Properties();
        Properties topicProps = new Properties();
        topicProps.put(LogConfig.CleanupPolicyProp(), "compact");
        InMemoryCache inMemoryStore = new InMemoryCache();
        StoreUtils.createAndInitKafkaStoreInstance(this.zkConnect, (Store<String, String>)inMemoryStore, kafkaProps);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdDifferentSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.connection.url", this.zkConnect);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString2", false));
        int size = 0;
        Iterator iter = kafkaStore.getAllKeys();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        Assert.assertEquals((long)1L, (long)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdSameSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.connection.url", this.zkConnect);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        int size = 0;
        Iterator iter = kafkaStore.getAllKeys();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        Assert.assertEquals((long)2L, (long)size);
    }
}

