/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.SSLClusterTestHarness;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreSSLAuthTest
extends SSLClusterTestHarness {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreSSLAuthTest.class);

    @Before
    public void setup() {
        log.debug("Zk conn url = " + this.zkConnect);
    }

    @After
    public void teardown() {
        log.debug("Shutting down");
    }

    @Test
    public void testInitialization() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.zkConnect, this.clientSslConfigs, this.requireSSLClientAuth());
        kafkaStore.close();
    }

    @Test(expected=StoreInitializationException.class)
    public void testInitializationWithoutClientAuth() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.zkConnect, this.clientSslConfigs, false);
        kafkaStore.close();
    }

    @Test(expected=StoreInitializationException.class)
    public void testDoubleInitialization() throws Exception {
        try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.zkConnect, this.clientSslConfigs, this.requireSSLClientAuth());){
            kafkaStore.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimplePut() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.zkConnect, this.clientSslConfigs, this.requireSSLClientAuth());
        String key = "Kafka";
        String value = "Rocks";
        try {
            kafkaStore.put((Object)key, (Object)value);
            String retrievedValue = (String)kafkaStore.get((Object)key);
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }
}

