/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import java.util.HashSet;
import java.util.Properties;
import kafka.admin.AdminUtils;
import kafka.log.LogConfig;
import kafka.server.ConfigType;
import kafka.utils.ZkUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

public class SchemaTopicTest
extends ClusterTestHarness {
    public SchemaTopicTest() {
        super(3, true);
    }

    @Test
    public void testSchemaTopicProperty() throws Exception {
        HashSet<String> topics = new HashSet<String>();
        topics.add("");
        Map partitionAssignment = (Map)this.zkUtils.getPartitionAssignmentForTopics(JavaConversions.asScalaSet(topics).toSeq()).get((Object)"").get();
        Assert.assertEquals((String)"There should be only 1 partition in the schema topic", (long)1L, (long)partitionAssignment.size());
        Seq replicas = (Seq)partitionAssignment.get((Object)0).get();
        Assert.assertEquals((String)"There should be 3 replicas in partition 0 in the schema topic", (long)3L, (long)replicas.size());
        Properties prop = AdminUtils.fetchEntityConfig((ZkUtils)this.zkUtils, (String)ConfigType.Topic(), (String)"");
        Assert.assertEquals((String)"The schema topic should have the compact retention policy", (Object)"compact", (Object)prop.getProperty(LogConfig.CleanupPolicyProp()));
    }
}

