/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveJsonSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DeriveJsonSchemaTest
extends DeriveSchemaTest {
    public DeriveJsonSchemaTest() {
        this.derive = new DeriveJsonSchema();
    }

    public void generateSchemaAndCheckExpected(List<String> messages, String expectedSchema) throws IOException {
        ArrayList<JsonNode> messagesJson = new ArrayList<JsonNode>();
        for (String message : messages) {
            messagesJson.add(this.mapper.readTree(message));
        }
        ObjectNode schemaString = this.derive.getSchemaForArray(messagesJson, "ArrayObject");
        JsonSchema schema = new JsonSchema(schemaString.toString());
        schema.validate(false);
        Assert.assertEquals((Object)schema.toString(), (Object)expectedSchema);
    }

    @Override
    public void matchAndValidate(String message, JsonNode schemaString, String expectedSchema) throws IOException {
        JsonSchema schema = new JsonSchema(schemaString.toString());
        schema.validate(false);
        schema.validate((JsonNode)this.mapper.readValue(message, ObjectNode.class));
        Assert.assertEquals((Object)schema.toString(), (Object)expectedSchema);
    }

    public void generateSchemasAndMatchExpectedMergeArrays(String schemaString1, String schemaString2, String ExpectedSchema) throws JsonProcessingException {
        JsonNode schema1 = this.mapper.readTree(schemaString1);
        JsonNode schema2 = this.mapper.readTree(schemaString2);
        ObjectNode schema = this.derive.mergeArrays(Arrays.asList(schema1, schema2), true, false);
        Assert.assertEquals((Object)ExpectedSchema, (Object)schema.toString());
    }

    public void generateSchemasAndMatchExpectedMergeRecords(String schemaString1, String schemaString2, String ExpectedSchema) throws JsonProcessingException {
        JsonNode schema1 = this.mapper.readTree(schemaString1);
        JsonNode schema2 = this.mapper.readTree(schemaString2);
        ObjectNode schema = this.derive.mergeRecords(Arrays.asList(schema1, schema2));
        Assert.assertEquals((Object)ExpectedSchema, (Object)schema.toString());
    }

    @Test
    public void testDerivePrimitive() throws JsonProcessingException {
        this.generateSchemaAndCheckPrimitive("12", "{\"type\":\"number\"}");
        this.generateSchemaAndCheckPrimitive("12.5", "{\"type\":\"number\"}");
        this.generateSchemaAndCheckPrimitive("12020210222344343333333333120202102223443", "{\"type\":\"number\"}");
        this.generateSchemaAndCheckPrimitive("true", "{\"type\":\"boolean\"}");
        this.generateSchemaAndCheckPrimitive("\"Test\"", "{\"type\":\"string\"}");
        this.generateSchemaAndCheckPrimitive("", "{\"type\":\"null\"}");
        this.generateSchemaAndCheckPrimitive("null", "{\"type\":\"null\"}");
    }

    @Test
    public void testDerivePrimitiveForComplex() throws JsonProcessingException {
        this.generateSchemaAndCheckPrimitiveAbsent("[12]");
        this.generateSchemaAndCheckPrimitiveAbsent("[1.5, true]");
        this.generateSchemaAndCheckPrimitiveAbsent("{\"F1\":12}");
        this.generateSchemaAndCheckPrimitiveAbsent("{\"F2\":\"12\"}");
    }

    @Test
    public void testDeriveRecordPrimitive() throws Exception {
        String stringMessage = "\"String\": \"Test\"";
        String nullMessage = "\"Null\": null";
        String primitiveTypesMessage = "{" + stringMessage + "," + nullMessage + "}";
        String expectedSchema = "{\"type\":\"object\",\"properties\":{\"Null\":{\"type\":\"null\"},\"String\":{\"type\":\"string\"}}}";
        this.generateSchemaAndCheckExpected(primitiveTypesMessage, expectedSchema);
    }

    @Test
    public void testDeriveRecordComplexTypesWithPrimitiveValues() throws IOException {
        String arrayOfNullsMessage = "\"RecordWithNull\": {\"Field\": null}";
        String recordOfMultipleMessage = "\"RecordWithNumber\": {\"Field\": \"62\"}";
        String complexTypesWithPrimitiveValues = "{" + arrayOfNullsMessage + "," + recordOfMultipleMessage + "}";
        String expectedSchema = "{\"type\":\"object\",\"properties\":{\"RecordWithNull\":{\"type\":\"object\",\"properties\":{\"Field\":{\"type\":\"null\"}}},\"RecordWithNumber\":{\"type\":\"object\",\"properties\":{\"Field\":{\"type\":\"string\"}}}}}";
        this.generateSchemaAndCheckExpected(complexTypesWithPrimitiveValues, expectedSchema);
    }

    @Test
    public void testDeriveRecordWithMergingOfFieldAndTypes() throws IOException {
        String arrayOfRecordsAndArrays = "{\"ArrayOfRecordsAndArrays\": [ {\"J\":[1,11]}, {\"J\":{\"J\":12}},  {\"J\":{\"J\": true}}]}";
        String expectedSchema2 = "{\"type\":\"object\",\"properties\":{\"ArrayOfRecordsAndArrays\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"J\":{\"oneOf\":[{\"type\":\"array\",\"items\":{\"type\":\"number\"}},{\"type\":\"object\",\"properties\":{\"J\":{\"oneOf\":[{\"type\":\"boolean\"},{\"type\":\"number\"}]}}}]}}}}}}";
        this.generateSchemaAndCheckExpected(arrayOfRecordsAndArrays, expectedSchema2);
    }

    @Test
    public void testDeriveArrayPrimitive() throws IOException {
        this.generateSchemaAndCheckExpected(new ArrayList<String>(), "{\"type\":\"array\",\"items\":{}}");
        String nullItem = "null";
        String nullItemsSchema = "{\"type\":\"array\",\"items\":{\"type\":\"null\"}}";
        this.generateSchemaAndCheckExpected(Arrays.asList(nullItem, nullItem), nullItemsSchema);
    }

    @Test
    public void testDeriveArrayTypeArray() throws IOException {
        String arrayOfStrings = "[\"1\"]";
        String arrayOfIntegers = "[3.5, true]";
        String expectedSchema = String.format("{\"type\":\"array\",\"items\":%s}", "{\"type\":\"array\",\"items\":{\"oneOf\":[{\"type\":\"boolean\"},{\"type\":\"number\"},{\"type\":\"string\"}]}}");
        this.generateSchemaAndCheckExpected(Arrays.asList(arrayOfStrings, arrayOfIntegers, arrayOfStrings, arrayOfIntegers), expectedSchema);
    }

    @Test
    public void testDeriveArrayTypeArrayComplex() throws IOException {
        String array3d = "[ [[1,2]], [[1,22]] ]";
        String expectedSchema3d = "{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"number\"}}}}}";
        this.generateSchemaAndCheckExpected(Arrays.asList(array3d, array3d), expectedSchema3d);
    }

    @Test
    public void testDeriveMultipleMessages() throws JsonProcessingException {
        JsonNode stringMessage = this.mapper.readTree("{\"string\": \"1\"}");
        JsonNode integerMessage = this.mapper.readTree("{\"number\": 12}");
        String expectedSchema = "{\"schemas\":[{\"schema\":{\"type\":\"object\",\"properties\":{\"number\":{\"type\":\"number\"},\"string\":{\"type\":\"string\"}}},\"messagesMatched\":[0,1,2,3]}]}";
        ObjectNode schema = this.derive.getSchemaForMultipleMessages(Arrays.asList(stringMessage, integerMessage, stringMessage, integerMessage));
        Assert.assertEquals((Object)expectedSchema, (Object)schema.toString());
    }

    @Test
    public void shouldMergeEmptyItemsMergeArrays() throws JsonProcessingException {
        this.generateSchemasAndMatchExpectedMergeArrays("{\"type\":\"array\",\"items\":{\"type\":\"number\"}}", "{\"type\":\"array\",\"items\":{}}", "{\"type\":\"array\",\"items\":{\"type\":\"number\"}}");
    }

    @Test
    public void shouldCombineOneOfTypesMergeArrays() throws JsonProcessingException {
        String arrayOfBoolean = "{\"type\":\"array\",\"items\":{\"type\":\"boolean\"}}";
        this.generateSchemasAndMatchExpectedMergeArrays("{\"type\":\"array\",\"items\":{\"oneOf\":[{\"type\":\"number\"},{\"type\":\"string\"}]}}", arrayOfBoolean, "{\"type\":\"array\",\"items\":{\"oneOf\":[{\"type\":\"boolean\"},{\"type\":\"number\"},{\"type\":\"string\"}]}}");
    }

    @Test
    public void shouldCombineArrayTypesMergeArrays() throws JsonProcessingException {
        String arrayOfArrayOfNumbersAndStrings = "{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"oneOf\":[{\"type\":\"number\"},{\"type\":\"string\"}]}}}";
        String arrayOfArrayOfStrings = "{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}";
        this.generateSchemasAndMatchExpectedMergeArrays(arrayOfArrayOfStrings, "{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"number\"}}}", arrayOfArrayOfNumbersAndStrings);
    }

    @Test
    public void shouldCombineFieldsMergeRecord() throws JsonProcessingException {
        String expectedSchema = "{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"string\"},\"F2\":{\"type\":\"string\"}}}";
        this.generateSchemasAndMatchExpectedMergeRecords(String.format("{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "F1"), String.format("{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "F2"), expectedSchema);
    }

    @Test
    public void shouldCombineFieldTypesMergeRecord() throws JsonProcessingException {
        String recordWithNumber = "{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"number\"}}}";
        String expectedSchema = "{\"type\":\"object\",\"properties\":{\"F1\":{\"oneOf\":[{\"type\":\"number\"},{\"type\":\"string\"}]}}}";
        this.generateSchemasAndMatchExpectedMergeRecords(String.format("{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "F1"), recordWithNumber, expectedSchema);
    }

    @Test
    public void shouldCombineFieldsOfDifferentTypesMergeRecord() throws JsonProcessingException {
        String expectedSchema = "{\"type\":\"object\",\"properties\":{\"F1\":{\"oneOf\":[{\"type\":\"array\",\"items\":{\"type\":\"string\"}},{\"type\":\"string\"}]}}}";
        this.generateSchemasAndMatchExpectedMergeRecords(String.format("{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "F1"), "{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}", expectedSchema);
    }
}

