/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.maven.MojoUtils;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveAvroSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveJsonSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveProtobufSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchema;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="derive-schema", configurator="custom-basic")
public class DeriveSchemaMojo
extends AbstractMojo {
    @Parameter(required=true)
    File messagePath;
    @Parameter(required=true)
    File outputPath;
    @Parameter(defaultValue="AVRO")
    String schemaType;
    protected static final ObjectMapper mapper = JacksonMapper.INSTANCE;

    public static void writeOutput(File outputPath, JsonNode schemaInformation) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(outputPath.getPath());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);
        writer.write(schemaInformation.toPrettyString());
        writer.close();
    }

    public static List<JsonNode> readLinesOfMessages(File messagePath) throws IOException {
        String content = MojoUtils.readFile(messagePath, StandardCharsets.UTF_8);
        ArrayList<JsonNode> listOfMessages = new ArrayList<JsonNode>();
        String[] lineSeparatedMessages = content.split("\n");
        for (int i = 0; i < lineSeparatedMessages.length; ++i) {
            if (lineSeparatedMessages[i].length() == 0) continue;
            try {
                listOfMessages.add((JsonNode)mapper.readValue(lineSeparatedMessages[i], ObjectNode.class));
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Message on line %d is an invalid JSON message", i + 1), e);
            }
        }
        return listOfMessages;
    }

    public void execute() throws MojoExecutionException {
        ObjectNode schemaInformation;
        DeriveSchema derive;
        List<JsonNode> listOfMessages;
        try {
            listOfMessages = DeriveSchemaMojo.readLinesOfMessages(this.messagePath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception thrown while reading input file", (Exception)e);
        }
        if (this.schemaType.equalsIgnoreCase("JSON")) {
            derive = new DeriveJsonSchema();
        } else if (this.schemaType.equalsIgnoreCase("PROTOBUF")) {
            derive = new DeriveProtobufSchema();
        } else if (this.schemaType.equalsIgnoreCase("AVRO")) {
            derive = new DeriveAvroSchema();
        } else {
            throw new MojoExecutionException("Schema type should be one of avro, json or protobuf");
        }
        try {
            schemaInformation = derive.getSchemaForMultipleMessages(listOfMessages);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception thrown while deriving schema", e);
        }
        try {
            DeriveSchemaMojo.writeOutput(this.outputPath, (JsonNode)schemaInformation);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception thrown while writing to output file", (Exception)e);
        }
    }
}

